/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;



public interface AllPropertyObserver extends PropertyObserver2<Object> {
	public class ElementAddedEvent extends PropEvent<Object, AllPropertyObserver> {
		private Object addedElement;
		private PropertyId2<?> realPid;
		public ElementAddedEvent(Object source, PropertyId2<?> realPid, Object addedElement) {
			super(source, PropChangedEventNotifier.allProperty);
			this.addedElement = addedElement;
			this.realPid = realPid;
		}
		public PropertyId2<?> getRealPid() {
			return realPid;
		}
		public Object getAddedElement() {
			return addedElement;
		}
		@Override
		public void dispatch(AllPropertyObserver observer) {
			observer.elementAdded(this);
		}
	}
	
	public class ElementRemovedEvent extends PropEvent<Object, AllPropertyObserver> {
		private Object removedValue;
		private PropertyId2<?> realPid;
		public ElementRemovedEvent(Object source, PropertyId2<?> realPid, Object addedValue) {
			super(source, PropChangedEventNotifier.allProperty);
			this.removedValue = addedValue;
			this.realPid = realPid;
		}
		public Object getRemovedElement() {
			return removedValue;
		}
		public PropertyId2<?> getRealPid() {
			return realPid;
		}
		@Override
		public void dispatch(AllPropertyObserver observer) {
			observer.elementRemoved(this);
		}
	}
	void elementAdded(ElementAddedEvent event);
	void elementRemoved(ElementRemovedEvent event);

	public class ValueChangedEvent extends PropEvent<Object, AllPropertyObserver> {
		private Object newValue;
		private Object oldValue;
		private PropertyId2<?> realPid;
		public ValueChangedEvent(Object source, PropertyId2<AllPropertyObserver> realPid, Object newValue, Object oldValue) {
			super(source, PropChangedEventNotifier.allProperty);
			this.newValue = newValue;
			this.oldValue = oldValue;
			this.realPid = realPid;
		}
		public Object getNewValue() {
			return newValue;
		}
		public Object getOldValue() {
			return oldValue;
		}
		public PropertyId2<?> getRealPid() {
			return realPid;
		}
		@Override
		public void dispatch(AllPropertyObserver observer) {
			if ((getNewValue() != null && !getNewValue().equals(getOldValue())) || getNewValue() != getOldValue()) {
				observer.propertyChanged(this);
			}
		}
	}
	void propertyChanged(ValueChangedEvent event);
}
