/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.presenter.TemplateJobsArgument;
import com.clustercontrol.util.Messages;

public class StartInstanceDialog extends Dialog {
	public static class DialogInput{
		private String accountResourceId;
		private String region;
		private String instanceId;
		private String templateId;
		public String getRegion() {
			return region;
		}
		public void setRegion(String region) {
			this.region = region;
		}
		public String getInstanceId() {
			return instanceId;
		}
		public void setInstanceId(String instanceId) {
			this.instanceId = instanceId;
		}
		public String getTemplateId() {
			return templateId;
		}
		public void setTemplateId(String templateId) {
			this.templateId = templateId;
		}
		public String getAccountResourceId() {
			return accountResourceId;
		}
		public void setAccountResourceId(String accountResourceId) {
			this.accountResourceId = accountResourceId;
		}
	}
	
	public static class DialogOutput{
		private Boolean runJobFlg;
		private String jobId;
		private List<TemplateJobsArgument> arguments;
		public Boolean getRunJobFlg() {
			return runJobFlg;
		}
		public void setRunJobFlg(Boolean runJobFlg) {
			this.runJobFlg = runJobFlg;
		}
		public List<TemplateJobsArgument> getArguments() {
			return arguments;
		}
		public void setArguments(List<TemplateJobsArgument> arguments) {
			this.arguments = arguments;
		}
		public void setJobId(String jobId) {
			this.jobId = jobId;
		}
		public String getJobId() {
			return jobId;
		}
	}

	private MessageManager messages = MessageManager.getInstance("messages");
	
	private String strSeparator = messages.getString("caption.title_separator");
	private String strInstanceId = messages.getString("word.instance_id");
	private String strTemplate = messages.getString("word.template");
	private String strRunJobFlagDescription = messages.getString("caption.run_job_flag_description_to_start");
	private String strTemplateJob = messages.getString("word.template_job");
	private String strEditArugment = messages.getString("caption.edit_argument");
	private String strChangeJobFlagDescription = messages.getString("caption.change_job_flag_description");
	private String msgMustFullyInput = messages.getString("message.must_fully_input");
	private String strStartInstanceDialog = messages.getString("caption.start_instance_dialog");
	
	private Shell shell;

	private Text instanceId;
	private Button btnRunJobFlg;
	private Button btnChangeJobFlg;
	private Combo templateJob;
	private Button btnEditArgument;
	
	private DialogInput input;
	private DialogOutput output;
		
	private ICloudTemplateManager templateManager;
	
	private List<TemplateJobsArgument> arguments;
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public StartInstanceDialog(Shell parentShell){
		super(parentShell);
		this.shell = parentShell;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);

		Label lblid = new Label(container, SWT.RIGHT);
		lblid.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblid.setText(strInstanceId + strSeparator);

		instanceId = new Text(container, SWT.BORDER);
		instanceId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);

		Group grpTemplate = new Group(container, SWT.NONE);
		grpTemplate.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));
		grpTemplate.setLayout(new GridLayout(2, false));
		grpTemplate.setText(strTemplate);
		
		btnRunJobFlg = new Button(grpTemplate, SWT.CHECK);
		btnRunJobFlg.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 2, 1));
		btnRunJobFlg.setText(strRunJobFlagDescription);
		
		btnChangeJobFlg = new Button(grpTemplate, SWT.CHECK);
		GridData gd_btnChangeJobFlg = new GridData(SWT.LEFT, SWT.CENTER, false, false, 2, 1);
		gd_btnChangeJobFlg.horizontalIndent = 30;
		btnChangeJobFlg.setLayoutData(gd_btnChangeJobFlg);
		btnChangeJobFlg.setText(strChangeJobFlagDescription);
		
		Label lblTemplate = new Label(grpTemplate, SWT.RIGHT);
		lblTemplate.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblTemplate.setText(strTemplateJob + strSeparator);
		
		templateJob = new Combo(grpTemplate, SWT.BORDER | SWT.READ_ONLY);
		GridData gd_templateJob = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_templateJob.widthHint = 100;
		templateJob.setLayoutData(gd_templateJob);
		
		new Label(grpTemplate, SWT.NONE);
		
		btnEditArgument = new Button(grpTemplate, SWT.NONE);
		btnEditArgument.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		btnEditArgument.setText(strEditArugment);

		//初期値セットアップ
		instanceId.setEnabled(false);
		btnChangeJobFlg.setEnabled(false);
		templateJob.setEnabled(false);
		btnEditArgument.setEnabled(false);
		
		if(input != null){
			instanceId.setText(input.getInstanceId());
			
			if(input.getTemplateId() != null && !input.getTemplateId().equals("")){
				btnRunJobFlg.setSelection(true);
				btnChangeJobFlg.setEnabled(true);
				try {
					Map<String, String> templateJobMap = new HashMap<String, String>();
					for(TemplateJobUtil.TemplateJobnet childJobItem : TemplateJobUtil.getTemplateJobList(input.getAccountResourceId(), true)){
						String jobId = childJobItem.getJobnetId();
						String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
						templateJob.add(jobName);
						templateJob.setData(jobName, jobId);
						templateJobMap.put(jobId, jobName);
					}
					if(templateJob.getItemCount() > 0){
						templateJob.select(0);
					}
					if(input != null && input.getTemplateId() != null && !input.getTemplateId().equals("")){
						ICloudTemplate template = null;
						for(ICloudTemplate tmpTemplate: templateManager.getCloudTemplates()){
							if(tmpTemplate.getTemplateId().equals(input.getTemplateId())){
								template = tmpTemplate;
								break;
							}
						}
						if(template != null && templateJobMap.containsKey(template.getStartJobId())){
							templateJob.select(templateJob.indexOf(templateJobMap.get(template.getStartJobId())));
						}
					}
				} catch (com.clustercontrol.ws.jobmanagement.InvalidRole_Exception e1){
					btnRunJobFlg.setSelection(false);
					MessageDialog.openError(null, Messages.getString("failed"), e1.getMessage());
				} catch (Exception e2) {
					throw new IllegalStateException(e2);
				}
			}
		}
		
		btnRunJobFlg.addSelectionListener(new SelectionAdapter(){
			private Boolean jobRead = false;
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(btnRunJobFlg.getSelection()){
					if(!jobRead && templateJob.getItemCount() < 1){
						try {
							Map<String, String> templateJobMap = new HashMap<String, String>();
							for(TemplateJobUtil.TemplateJobnet childJobItem : TemplateJobUtil.getTemplateJobList(input.getAccountResourceId(), true)){
								String jobId = childJobItem.getJobnetId();
								String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
								templateJob.add(jobName);
								templateJob.setData(jobName, jobId);
								templateJobMap.put(jobId, jobName);
							}
							if(templateJob.getItemCount() > 0){
								templateJob.select(0);
							}
							if(input != null && input.getTemplateId() != null && !input.getTemplateId().equals("")){
								ICloudTemplate template = null;
								for(ICloudTemplate tmpTemplate: templateManager.getCloudTemplates()){
									if(tmpTemplate.getTemplateId().equals(input.getTemplateId())){
										template = tmpTemplate;
										break;
									}
								}
								if(template != null && templateJobMap.containsKey(template.getStartJobId())){
									templateJob.select(templateJob.indexOf(templateJobMap.get(template.getStartJobId())));
								}
							}
						} catch (com.clustercontrol.ws.jobmanagement.InvalidRole_Exception e1){
							btnRunJobFlg.setSelection(false);
							MessageDialog.openError(null, Messages.getString("failed"), e1.getMessage());
							return;
						} catch (Exception e2) {
							throw new IllegalStateException(e2);
						}
						jobRead = true;
					}
					btnChangeJobFlg.setEnabled(true);
					if(btnChangeJobFlg.getSelection()){
						templateJob.setEnabled(true);
						btnEditArgument.setEnabled(true);
					}
				} else {
					btnChangeJobFlg.setEnabled(false);
					templateJob.setEnabled(false);
					btnEditArgument.setEnabled(false);
				}
			}
		});

		btnChangeJobFlg.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(btnChangeJobFlg.getSelection()){
					templateJob.setEnabled(true);
					btnEditArgument.setEnabled(true);
				} else {
					templateJob.setEnabled(false);
					btnEditArgument.setEnabled(false);
				}
			}
		});
		
		btnEditArgument.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(templateJob.getText().equals("")){
					return;
				}
				String templateId = null;
				if(input != null && input.getTemplateId() != null && !input.getTemplateId().equals("")){
					templateId =input.getTemplateId();
				} else {
					templateId = "";
				}
				EditTemplateJobArgumentDialog dialog = new EditTemplateJobArgumentDialog(shell, input.getAccountResourceId(), templateId, (String)templateJob.getData(templateJob.getText()));

				if (dialog.open() == Window.OK) {
					arguments = dialog.getArguments();
				}
			}
		});

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(480, 320);
	}

	@Override
	protected void okPressed() {
		if(btnRunJobFlg.getSelection() && templateJob.getText().equals("")){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					msgMustFullyInput);
			return;
		}
		
		output = new DialogOutput();
		output.setRunJobFlg(btnRunJobFlg.getSelection());
		if(btnRunJobFlg.getSelection()){
			output.setJobId((String)(templateJob.getData(templateJob.getText())));
			if(arguments != null && arguments.size() > 0){
				output.setArguments(arguments);
			}
		}
				
		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strStartInstanceDialog);
	}

	public void setInput(DialogInput input) {
		this.input = input;
		templateManager = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(input.getAccountResourceId()).getCloudTemplateManager();
	}

	public DialogOutput getOutput() {
		return output;
	}
}
