/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.base.ui.dialogs;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.ui.dialogs.CreateEndPointDialog;
import com.clustercontrol.cloud.azure.base.ui.dialogs.CreateInstanceDialog;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.EndPoint;
import com.clustercontrol.ws.notify.NotifyRelationInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class RegistEndPointDialog
extends CommonDialog {
    private final int sizeX = 640;
    private final int sizeY = 450;
    private Button buttonAdd = null;
    private Button buttonModify = null;
    private Button buttonDelete = null;
    private Table table;
    private TableItem[] item;
    Boolean endPointFlg;
    private String osType = "dummy";
    private CreateInstanceDialog.Model output;
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strEndPoint = this.messages.getString("caption.regist_end_point_dialog");
    private String strName = this.messages.getString("word.name");
    private String strProtcol = this.messages.getString("word.protocol");
    private String strPublicPort = this.messages.getString("word.public_port");
    private String strPrivatePort = this.messages.getString("word.private_port");
    private String strAuto = this.messages.getString("word.port_auto");
    private String msgMustEndPoint = this.messages.getString("message.must_select_end_point");
    private String msgMustDeleteEndPoint = this.messages.getString("message.must_delete_select_end_point");
    List<NotifyRelationInfo> notify;
    List<EndPoint> endPoint = new ArrayList<EndPoint>();

    public RegistEndPointDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    public RegistEndPointDialog(Shell parent, boolean isSelect, int notifyIdType, String ownerRoleId) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected Point getInitialSize() {
        return new Point(640, 450);
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(this.strEndPoint);
        GridLayout layout = new GridLayout(8, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 8;
        parent.setLayout((Layout)layout);
        this.table = new Table(parent, 67584);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 7;
        gridData.heightHint = 128;
        this.table.setLayoutData((Object)gridData);
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(130);
        tableColumn_1.setText(this.strName);
        TableColumn tableColumn_2 = new TableColumn(this.table, 0);
        tableColumn_2.setWidth(130);
        tableColumn_2.setText(this.strProtcol);
        TableColumn tableColumn_3 = new TableColumn(this.table, 0);
        tableColumn_3.setWidth(130);
        tableColumn_3.setText(this.strPublicPort);
        TableColumn tableColumn_4 = new TableColumn(this.table, 0);
        tableColumn_4.setWidth(132);
        tableColumn_4.setText(this.strPrivatePort);
        this.endPoint = this.getEndPoint();
        ArrayList<EndPoint> availableVolumes = new ArrayList<EndPoint>(this.endPoint);
        for (EndPoint endPoint : availableVolumes) {
            TableItem item = new TableItem(this.table, 0);
            String[] data = new String[]{endPoint.getName(), endPoint.getProtocol(), endPoint.getPublicPort() == null ? this.strAuto : endPoint.getPublicPort().toString(), endPoint.getPrivatePort().toString()};
            item.setText(data);
            this.table.setSelection(0);
        }
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite.setLayoutData((Object)gridData);
        this.buttonAdd = this.createButton(composite, Messages.getString((String)"add"));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateEndPointDialog dialog = new CreateEndPointDialog(RegistEndPointDialog.this.getParentShell());
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    RegistEndPointDialog.this.endPoint = dialog.getEndPoint();
                    ArrayList<EndPoint> availableVolumes = new ArrayList<EndPoint>(RegistEndPointDialog.this.endPoint);
                    for (EndPoint endPoint : availableVolumes) {
                        TableItem item = new TableItem(RegistEndPointDialog.this.table, 0);
                        String[] data = new String[]{endPoint.getName(), endPoint.getProtocol(), endPoint.getPublicPort() == null ? RegistEndPointDialog.this.strAuto : endPoint.getPublicPort().toString(), endPoint.getPrivatePort().toString()};
                        item.setText(data);
                        RegistEndPointDialog.this.table.setSelection(0);
                    }
                }
            }
        });
        Label dummy = new Label(composite, 0);
        this.buttonModify = this.createButton(composite, Messages.getString((String)"modify"));
        this.buttonModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectIndex;
                RegistEndPointDialog.access$302(RegistEndPointDialog.this, RegistEndPointDialog.this.table.getSelection());
                CreateEndPointDialog action = new CreateEndPointDialog(RegistEndPointDialog.this.getParentShell());
                if (RegistEndPointDialog.this.item != null && RegistEndPointDialog.this.item.length > 0) {
                    selectIndex = RegistEndPointDialog.this.table.getSelectionIndex();
                    RegistEndPointDialog.this.table.setSelection(selectIndex);
                    action.setEndPointName(RegistEndPointDialog.this.table.getItem(selectIndex).getText(0));
                    action.setProtocol(RegistEndPointDialog.this.table.getItem(selectIndex).getText(1));
                    action.setPublicPort(RegistEndPointDialog.this.table.getItem(selectIndex).getText(2));
                    action.setPrivatePort(RegistEndPointDialog.this.table.getItem(selectIndex).getText(3));
                    action.open();
                } else {
                    MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)RegistEndPointDialog.this.msgMustEndPoint);
                }
                if (action.getReturnCode() == 0) {
                    RegistEndPointDialog.this.endPoint = action.getEndPoint();
                    selectIndex = RegistEndPointDialog.this.table.getSelectionIndex();
                    ArrayList<EndPoint> availableVolumes = new ArrayList<EndPoint>(RegistEndPointDialog.this.endPoint);
                    for (EndPoint endPoint : availableVolumes) {
                        TableItem item = RegistEndPointDialog.this.table.getItem(selectIndex);
                        String[] data = new String[]{endPoint.getName(), endPoint.getProtocol(), endPoint.getPublicPort() == null ? RegistEndPointDialog.this.strAuto : endPoint.getPublicPort().toString(), endPoint.getPrivatePort().toString()};
                        item.setText(data);
                        RegistEndPointDialog.this.table.setSelection(0);
                    }
                }
            }
        });
        dummy = new Label(composite, 0);
        this.buttonDelete = this.createButton(composite, Messages.getString((String)"delete"));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RegistEndPointDialog.access$302(RegistEndPointDialog.this, RegistEndPointDialog.this.table.getSelection());
                if (RegistEndPointDialog.this.item != null && RegistEndPointDialog.this.item.length > 0) {
                    try {
                        int selectIndex = RegistEndPointDialog.this.table.getSelectionIndex();
                        RegistEndPointDialog.this.table.remove(selectIndex);
                        RegistEndPointDialog.this.endPoint.remove(selectIndex);
                    }
                    catch (Exception exception) {}
                } else {
                    MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)RegistEndPointDialog.this.msgMustDeleteEndPoint);
                }
            }
        });
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        shell.pack();
        shell.setSize(new Point(640, 450));
    }

    protected void okPressed() {
        this.endPoint.clear();
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            EndPoint ep = new EndPoint();
            ep.setName(this.table.getItem(i).getText(0));
            ep.setProtocol(this.table.getItem(i).getText(1));
            ep.setPublicPort(this.table.getItem(i).getText(2).equals(this.strAuto) ? null : Integer.valueOf(Integer.parseInt(this.table.getItem(i).getText(2))));
            ep.setPrivatePort(Integer.valueOf(Integer.parseInt(this.table.getItem(i).getText(3))));
            this.endPoint.add(ep);
        }
        this.setReturnCode(0);
        this.close();
    }

    protected void cancelPressed() {
        this.endPoint.clear();
        this.close();
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(label);
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public CreateInstanceDialog.Model getOutput() {
        return this.output;
    }

    public void setEndPoint(List<EndPoint> endPoint) {
        this.endPoint = endPoint;
    }

    public List<EndPoint> getEndPoint() {
        return this.endPoint;
    }

    public void setTableItem(TableItem[] item) {
        this.item = item;
    }

    public void setOStype(String osType) {
        this.osType = osType;
    }

    public String getOStype() {
        return this.osType;
    }

    static /* synthetic */ TableItem[] access$302(RegistEndPointDialog x0, TableItem[] x1) {
        x0.item = x1;
        return x1;
    }
}

