/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.base.ui.dialogs;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.azure.base.resources.Filter;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.AzureImage;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectVMIDialog
extends Dialog {
    private Text filter;
    private org.eclipse.swt.widgets.List vmi;
    private Button btnSearch;
    private String region;
    private CloudResourceProvider provider;
    private AzureImage output;
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strSeparator = this.messages.getString("caption.title_separator");
    private String strFilter = this.messages.getString("word.filter");
    private String strSearchVmi = this.messages.getString("word.search_vmi");
    private String msgMustInputSearchText = this.messages.getString("message.must_input_search_text");
    private String strVmiList = this.messages.getString("word.vmi_list");
    private String msgMustSelectVmi = this.messages.getString("message.must_select_vmi");
    private String strSelectVmiDialog = this.messages.getString("caption.select_vmi_dialog");

    public SelectVMIDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblTestfilter = new Label(container, 0);
        lblTestfilter.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTestfilter.setText(this.strFilter + this.strSeparator);
        this.filter = new Text(container, 2048);
        this.filter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnSearch = new Button(container, 0);
        this.btnSearch.setText(this.strSearchVmi);
        this.btnSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SelectVMIDialog.this.filter.getText() == "") {
                    MessageDialog.openWarning(null, (String)Messages.getString((String)"failed"), (String)SelectVMIDialog.this.msgMustInputSearchText);
                    return;
                }
                SelectVMIDialog.this.vmi.removeAll();
                Filter f1 = new Filter();
                f1.setName("name");
                f1.setValues(Arrays.asList("*" + SelectVMIDialog.this.filter.getText() + "*"));
                Filter f2 = new Filter();
                f2.setName("image-type");
                f2.setValues(Arrays.asList("machine"));
                try {
                    List<AzureImage> imgs = SelectVMIDialog.this.provider.getImages(SelectVMIDialog.this.region, SelectVMIDialog.this.filter.getText());
                    for (AzureImage img : imgs) {
                        String itemName = "(" + img.getImageId() + ") " + img.getName();
                        SelectVMIDialog.this.vmi.add(itemName);
                        SelectVMIDialog.this.vmi.setData(itemName, (Object)img);
                    }
                }
                catch (Exception e1) {
                    Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)e1.getMessage());
                }
            }
        });
        Label lblVmiList = new Label(container, 0);
        lblVmiList.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        lblVmiList.setText(this.strVmiList + this.strSeparator);
        this.vmi = new org.eclipse.swt.widgets.List(container, 2816);
        GridData gd_vmi = new GridData(4, 4, false, false, 2, 1);
        gd_vmi.heightHint = 303;
        gd_vmi.widthHint = 459;
        this.vmi.setLayoutData((Object)gd_vmi);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(700, 480);
    }

    protected void okPressed() {
        if (this.vmi.getSelection().length == 0) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgMustSelectVmi);
            return;
        }
        this.output = (AzureImage)this.vmi.getData(this.vmi.getSelection()[0]);
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.strSelectVmiDialog);
    }

    public AzureImage getOutput() {
        return this.output;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setCloudInfoProvider(CloudResourceProvider provider) {
        this.provider = provider;
    }
}

