/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.base.ui.views.actions;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.azure.base.ui.dialogs.AttachStorageFromInstanceDialog;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.ui.views.InstancesView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.AzureCreateStorageRequest;
import com.clustercontrol.ws.azure.DataVirtualHardDisks;
import com.clustercontrol.ws.azure.InstanceInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class AttachStorageFromInstanceAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgAttachStorageConfirm = this.messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.storage", "word.attach"});
    private String msgAttachStorageResult = this.messages.getString("message.some_command_has_been_accepted", new Object[]{"word.storage", "word.attach"});

    protected void invoke(IAction action) throws InvocationException {
        ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        AttachStorageFromInstanceDialog dialog = new AttachStorageFromInstanceDialog(this.viewPart.getSite().getShell(), instance);
        InstancesView view = (InstancesView)this.viewPart;
        String cui = instance.getCloudUserId();
        String ak = view.getCurrentAccountResource().getCloudUserManager().getCloudUser(cui).getAccessKey();
        IAccountResource.IRegion region = view.getActiveRegion();
        CloudResourceProviderImpl provider = new CloudResourceProviderImpl(region.getAccountResource().getAccountResourceId());
        String rg = region.getRegion();
        String ii = instance.getInstanceId();
        List<DataVirtualHardDisks> dvhds = provider.getDataVirtualHardDisk(rg, ii);
        List<InstanceInfo> instances = provider.getInstanceByCloudService(rg, instance.getZone());
        ArrayList<String> luns = new ArrayList<String>();
        for (InstanceInfo instanceinfo : instances) {
            if (!instanceinfo.getInstanceName().equals(ii)) continue;
            for (int i = 0; i <= 15; ++i) {
                if (instanceinfo.getAttachedLun().contains(i)) continue;
                luns.add(Integer.toString(i));
            }
        }
        dialog.setLuns(luns);
        dialog.setSubscriptionId(ak);
        dialog.setDataVirtualHardDisks(dvhds);
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)(this.msgAttachStorageConfirm + "\n" + dialog.getStorageId()))) {
                AzureCreateStorageRequest request = new AzureCreateStorageRequest();
                request.setVirtualHardDiskHostCaching(dialog.getHostCaching());
                request.setInstanceName(ii);
                request.setLUN(dialog.getLun());
                request.setCloudServiceName(instance.getZone());
                provider.atachStorage(rg, request.getInstanceName(), dialog.getStorageId(), request);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgAttachStorageResult);
            } else {
                return;
            }
        }
    }

    protected boolean canEnabled(IStructuredSelection selection) {
        ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        return !instance.getRegistState().equals(ICloudInstance.RegistStateType.deleted.name());
    }
}

