/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.base.ui.views.actions;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.azure.base.ui.dialogs.AttachStorageFromStorageDialog;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.cloud.ui.views.StoragesView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.AzureCreateStorageRequest;
import com.clustercontrol.ws.azure.InstanceInfo;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class AttachStorageFromStorageAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgAttachStorageConfirm = this.messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.storage", "word.attach"});
    private String msgAttachStorageResult = this.messages.getString("message.some_command_has_been_accepted", new Object[]{"word.storage", "word.attach"});

    protected void invoke(IAction action) throws InvocationException {
        StoragesView view = (StoragesView)this.viewPart;
        IAccountResource.IRegion region = view.getActiveRegion();
        if (region == null) {
            assert (view.getCurrentAccountResource().getRegions().length > 0);
            region = view.getCurrentAccountResource().getRegions()[0];
        }
        ICloudStorage storage = (ICloudStorage)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        AttachStorageFromStorageDialog dialog = new AttachStorageFromStorageDialog(this.viewPart.getSite().getShell(), storage);
        ICloudStorage[] iCloudStorage = storage.getCloudStorageManager().getCloudStorages();
        int diskSize = 0;
        for (int i = 0; i < iCloudStorage.length; ++i) {
            if (iCloudStorage[i].getStorageAttachment() == null) continue;
            diskSize += iCloudStorage[i].getSize().intValue();
        }
        dialog.setDiskSize(diskSize);
        CloudResourceProviderImpl provider = new CloudResourceProviderImpl(region.getAccountResource().getAccountResourceId());
        String cui = view.getCurrentAccountResource().getActiveUser().getCloudUserId();
        String ak = view.getCurrentAccountResource().getCloudUserManager().getCloudUser(cui).getAccessKey();
        String rg = region.getRegion();
        String cloudServiceName = "";
        cloudServiceName = view.getActiveZone() == null ? "" : view.getActiveZone();
        cloudServiceName = storage.getZone() == null ? "" : storage.getZone();
        List<InstanceInfo> instanceInfo = provider.getInstanceByCloudService(rg, cloudServiceName);
        dialog.setSubscriptionId(ak);
        dialog.setInstanceInfo(instanceInfo);
        dialog.setCloudService(cloudServiceName);
        if (dialog.open() == 0 && MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)(this.msgAttachStorageConfirm + "\n" + storage.getStorageId()))) {
            AzureCreateStorageRequest request = new AzureCreateStorageRequest();
            request.setVirtualHardDiskHostCaching(dialog.getHostCaching());
            request.setInstanceName(dialog.getInstanceId());
            request.setLUN(dialog.getLun());
            request.setCloudServiceName(cloudServiceName);
            provider.atachStorage(rg, request.getInstanceName(), storage.getStorageId(), request);
            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgAttachStorageResult);
        }
    }

    protected boolean canEnabled(IStructuredSelection selection) {
        for (ICloudStorage storage : selection) {
            if (storage.getStorageAttachment() == null && !storage.getRegistState().equals(ICloudStorage.RegistStateType.deleted.name())) continue;
            return false;
        }
        return true;
    }
}

