/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.base.ui.views.actions;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.azure.base.ui.dialogs.CreateInstanceDialog;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceRequest;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.resources.Tag;
import com.clustercontrol.cloud.ui.views.InstancesView;
import com.clustercontrol.cloud.ui.views.actions.AbstractViewAction;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.AzureCreateInstanceRequest;
import com.clustercontrol.ws.azure.NodeDetail;
import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;

public class CreateInstanceAction
extends AbstractViewAction {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgCreateInstanceConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.instance", "word.create"});
    private String msgCreateInstanceResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.instance", "word.create"}) + this.messages.getString("message.create_instance_notification");

    protected void invoke(IAction action) throws InvocationException {
        CreateInstanceDialog dialog = new CreateInstanceDialog(this.viewPart.getSite().getShell());
        final InstancesView view = (InstancesView)this.viewPart;
        IAccountResource.IRegion region = view.getActiveRegion();
        if (region == null) {
            assert (view.getCurrentAccountResource().getRegions().length > 0);
            region = view.getCurrentAccountResource().getRegions()[0];
        }
        ICloudComputeService service = (ICloudComputeService)region.getCloudService(ICloudComputeService.class);
        final ICloudTemplateManager templateManager = region.getAccountResource().getCloudTemplateManager();
        if (region != null) {
            CreateInstanceDialog.Model m = new CreateInstanceDialog.Model();
            m.setRegionName(region.getRegionName());
        }
        CloudResourceProviderImpl provider = new CloudResourceProviderImpl(region.getAccountResource().getAccountResourceId());
        dialog.setupCloudService(provider.getAvailabilityZones(region.getRegion()));
        dialog.setCloudInfoProvider(provider);
        dialog.setCurrentRegion(region.getRegion());
        dialog.setBehavior(new CreateInstanceDialog.DialogBehavior(){
            private Combo region;

            @Override
            public void setupRegion(Combo cmbRegion) {
                super.setupRegion(cmbRegion);
                if (view != null && view.getActiveRegion() != null && cmbRegion.indexOf(view.getActiveRegion().getRegionName()) != -1) {
                    cmbRegion.select(cmbRegion.indexOf(view.getActiveRegion().getRegionName()));
                } else if (cmbRegion.getItemCount() > 0) {
                    cmbRegion.select(0);
                }
            }

            @Override
            public void setupSelectImageFlg(Button rdoAmi, Button rdoTemplate) {
                rdoAmi.setSelection(true);
                rdoTemplate.setSelection(false);
            }

            @Override
            public void setupTemplate(Button useTemplate, Combo template, Button editArgument) {
                for (ICloudTemplate tmpTemplate : templateManager.getCloudTemplates()) {
                    if (!tmpTemplate.getRegion().equals(this.region.getData(this.region.getText()))) continue;
                    String tmpLabel = tmpTemplate.getTemplateName() + " ( " + tmpTemplate.getTemplateId() + " )";
                    template.add(tmpLabel);
                    template.setData(tmpLabel, (Object)tmpTemplate);
                }
                template.setEnabled(false);
                editArgument.setEnabled(false);
            }
        });
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgCreateInstanceConfirm)) {
                CreateInstanceDialog.Model m = dialog.getOutput();
                IAccountResource.IRegion r = service.getRegion();
                AzureCreateInstanceRequest azureRequest = new AzureCreateInstanceRequest();
                CreateCloudInstanceRequest cloudRequest = new CreateCloudInstanceRequest();
                String regionName = region.getRegion();
                NodeDetail nodeDetail = new NodeDetail();
                nodeDetail.setFacilityId(dialog.getOutput().getFacilityId());
                nodeDetail.setFacilityName(dialog.getOutput().getFacilityName());
                nodeDetail.setReplaceNode(dialog.getOutput().getReplaceNode());
                nodeDetail.setDescription(dialog.getOutput().getDescription());
                nodeDetail.setNodeName(dialog.getOutput().getNodeName());
                azureRequest.setNodeDetail(nodeDetail);
                azureRequest.setCloudServiceName(dialog.getOutput().getCloudServiceName());
                azureRequest.setStorageAccountName(dialog.getOutput().getStorageAccountName());
                azureRequest.setContainerName(dialog.getOutput().getContainerName());
                azureRequest.setSize(dialog.getOutput().getSize());
                azureRequest.setAccountName(dialog.getOutput().getNewUserName());
                if (dialog.getOutput().getPassword().equals(dialog.getOutput().getRePassword())) {
                    azureRequest.setPassWord(dialog.getOutput().getPassword());
                }
                azureRequest.setImage(dialog.getOutput().getAzureImage());
                azureRequest.setOSType(dialog.getOutput().getAzureImage().getOStype());
                azureRequest.setImageId(dialog.getOutput().getAzureImage().getName());
                azureRequest.getEndPoint().addAll(dialog.getOutput().getEndPoint());
                azureRequest.setAvailabilitySet(dialog.getOutput().getIsAvailabilitySet());
                azureRequest.setAvailabilitySetName(dialog.getOutput().getAvailabilitySetNmae());
                cloudRequest.setFacilityId(dialog.getOutput().getFacilityId());
                cloudRequest.setFacilityName(dialog.getOutput().getFacilityName());
                cloudRequest.setDescription(dialog.getOutput().getDescription());
                cloudRequest.setImageId(dialog.getOutput().getAzureImage().getImageId());
                cloudRequest.setNodeName(dialog.getOutput().getNodeName());
                cloudRequest.setReplaceNode(dialog.getOutput().getReplaceNode());
                cloudRequest.setZone(dialog.getOutput().getCloudServiceName());
                ArrayList<Tag> tags = new ArrayList<Tag>();
                Tag Tag_platform = new Tag();
                Tag_platform.name = "PlatForm";
                Tag_platform.value = dialog.getOutput().getAzureImage().getOStype();
                tags.add(Tag_platform);
                Tag Tag_NodeName = new Tag();
                Tag_NodeName.name = "NodeName";
                Tag_NodeName.value = dialog.getOutput().getNodeName();
                tags.add(Tag_NodeName);
                cloudRequest.setTags(tags);
                ((ICloudComputeService)r.getAccountResource().getRegion(m.getRegionName()).getCloudService(ICloudComputeService.class)).getInstanceManager().createCloudInstance(cloudRequest);
                provider.createInstance(regionName, azureRequest);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgCreateInstanceResult);
                view.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FacilityTree.refresh();
                    }
                });
            } else {
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
    }
}

