/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.base.ui.views.actions;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.azure.base.ui.dialogs.DetachStorageFromInstanceDialog;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.ui.views.InstancesView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.InstanceInfo;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DetachStorageFromInstanceAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgDetachStorageConfirm = this.messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.storage", "word.detach"});
    private String msgDetachStorageResult = this.messages.getString("message.some_command_has_been_accepted", new Object[]{"word.storage", "word.detach"});

    protected void invoke(IAction action) throws InvocationException {
        ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        DetachStorageFromInstanceDialog dialog = new DetachStorageFromInstanceDialog(this.viewPart.getSite().getShell(), instance);
        InstancesView view = (InstancesView)this.viewPart;
        String cui = instance.getCloudUserId();
        String ak = view.getCurrentAccountResource().getCloudUserManager().getCloudUser(cui).getAccessKey();
        IAccountResource.IRegion region = view.getActiveRegion();
        CloudResourceProviderImpl provider = new CloudResourceProviderImpl(region.getAccountResource().getAccountResourceId());
        String rg = region.getRegion();
        String ii = instance.getInstanceId();
        List<InstanceInfo> instances = provider.getInstanceByCloudService(rg, instance.getZone());
        dialog.setSubscriptionId(ak);
        for (InstanceInfo instanceinfo : instances) {
            if (!instanceinfo.getInstanceName().equals(ii)) continue;
            dialog.setDataVirtualHardDisks(instanceinfo);
        }
        if (dialog.open() == 0) {
            StringBuffer sb = new StringBuffer();
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)(this.msgDetachStorageConfirm + "\n" + sb))) {
                provider.detachStorage(region.getRegion(), dialog.getInstanceID(), dialog.getStorageID());
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgDetachStorageResult);
            } else {
                return;
            }
        }
    }

    protected boolean canEnabled(IStructuredSelection selection) {
        ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        return !instance.getRegistState().equals(ICloudInstance.RegistStateType.deleted.name());
    }
}

