/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.base.ui.views.actions;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.azure.base.ui.dialogs.CreateTemplateDialog;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.ModifyCloudTemplateRequest;
import com.clustercontrol.cloud.ui.views.TemplatesView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class ModifyTemplateAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgModifyTemplateConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.template", "word.modify"});
    private String msgModifyTemplateResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.template", "word.modify"});
    private CloudResourceProvider provider;
    private ICloudTemplate template;

    protected void invoke(IAction action) throws InvocationException {
        this.template = (ICloudTemplate)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        final IAccountResource accountResource = ((TemplatesView)this.viewPart).getAccountResource();
        this.provider = new CloudResourceProviderImpl(accountResource.getAccountResourceId());
        CreateTemplateDialog dialog = new CreateTemplateDialog(this.viewPart.getSite().getShell());
        dialog.setCloudInfoProvider(this.provider);
        try {
            dialog.setBehavior(new CreateTemplateDialog.DialogBehavior(){
                private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
                private List<TemplateJobUtil.TemplateJobnet> templateJobs;
                {
                    try {
                        this.templateJobs = TemplateJobUtil.getTemplateJobList((String)accountResource.getAccountResourceId(), (Boolean)true);
                    }
                    catch (InvalidRole_Exception e) {
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)e.getMessage());
                        this.templateJobs = new ArrayList<TemplateJobUtil.TemplateJobnet>();
                    }
                }

                @Override
                public void setupTemplateId(Text templateId) {
                    if (ModifyTemplateAction.this.template != null) {
                        templateId.setText(ModifyTemplateAction.this.template.getTemplateId());
                        templateId.setEditable(false);
                    }
                }

                @Override
                public void setupTemplateName(Text templateName) {
                    if (ModifyTemplateAction.this.template != null && ModifyTemplateAction.this.template.getTemplateName() != null && !ModifyTemplateAction.this.template.getTemplateName().isEmpty()) {
                        templateName.setText(ModifyTemplateAction.this.template.getTemplateName());
                    }
                }

                @Override
                public void setupRegion(Combo region) {
                    for (String regionName : ModifyTemplateAction.this.provider.getAllRegion()) {
                        String regionLocaleName = this.messages.getString(regionName);
                        region.add(regionLocaleName);
                        region.setData(regionLocaleName, (Object)regionName);
                    }
                    if (ModifyTemplateAction.this.template != null && ModifyTemplateAction.this.template.getRegion() != null && !ModifyTemplateAction.this.template.getRegion().equals("")) {
                        String regionLocaleName = this.messages.getString(ModifyTemplateAction.this.template.getRegion());
                        region.select(region.indexOf(regionLocaleName));
                    } else {
                        region.select(0);
                    }
                }

                @Override
                public void setupLaunchJobId(Combo launchJobId) {
                    HashMap<String, String> tmpMap = new HashMap<String, String>();
                    for (TemplateJobUtil.TemplateJobnet childJobItem : this.templateJobs) {
                        String jobId = childJobItem.getJobnetId();
                        String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
                        tmpMap.put(jobId, jobName);
                        launchJobId.add(jobName);
                        launchJobId.setData(jobName, (Object)jobId);
                    }
                    if (ModifyTemplateAction.this.template != null && ModifyTemplateAction.this.template.getLaunchJobId() != null && !ModifyTemplateAction.this.template.getLaunchJobId().equals("") && tmpMap.containsKey(ModifyTemplateAction.this.template.getLaunchJobId())) {
                        launchJobId.select(launchJobId.indexOf((String)tmpMap.get(ModifyTemplateAction.this.template.getLaunchJobId())));
                    }
                }

                @Override
                public void setupStartJobId(Combo startJobId) {
                    HashMap<String, String> tmpMap = new HashMap<String, String>();
                    for (TemplateJobUtil.TemplateJobnet childJobItem : this.templateJobs) {
                        String jobId = childJobItem.getJobnetId();
                        String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
                        tmpMap.put(jobId, jobName);
                        startJobId.add(jobName);
                        startJobId.setData(jobName, (Object)jobId);
                    }
                    if (ModifyTemplateAction.this.template != null && ModifyTemplateAction.this.template.getStartJobId() != null && !ModifyTemplateAction.this.template.getStartJobId().equals("") && tmpMap.containsKey(ModifyTemplateAction.this.template.getStartJobId())) {
                        startJobId.select(startJobId.indexOf((String)tmpMap.get(ModifyTemplateAction.this.template.getStartJobId())));
                    }
                }

                @Override
                public void setupStopJobId(Combo stopJobId) {
                    HashMap<String, String> tmpMap = new HashMap<String, String>();
                    for (TemplateJobUtil.TemplateJobnet childJobItem : this.templateJobs) {
                        String jobId = childJobItem.getJobnetId();
                        String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
                        tmpMap.put(jobId, jobName);
                        stopJobId.add(jobName);
                        stopJobId.setData(jobName, (Object)jobId);
                    }
                    if (ModifyTemplateAction.this.template != null && ModifyTemplateAction.this.template.getStopJobId() != null && !ModifyTemplateAction.this.template.getStopJobId().equals("") && tmpMap.containsKey(ModifyTemplateAction.this.template.getStopJobId())) {
                        stopJobId.select(stopJobId.indexOf((String)tmpMap.get(ModifyTemplateAction.this.template.getStopJobId())));
                    }
                }
            });
        }
        catch (Exception e) {
            throw new InvocationException((Throwable)e);
        }
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgModifyTemplateConfirm)) {
                ModifyCloudTemplateRequest request = new ModifyCloudTemplateRequest();
                request.setImageId(dialog.getOutput().getImageId());
                request.setJobUnitId(this.template.getJobUnitId());
                request.setLaunchJobId(dialog.getOutput().getLaunchJobId());
                request.setStartJobId(dialog.getOutput().getStartJobId());
                request.setStopJobId(dialog.getOutput().getStopJobId());
                request.setRegion(dialog.getOutput().getRegion());
                request.setTemplateId(dialog.getOutput().getTemplateId());
                request.setTemplateName(dialog.getOutput().getTemplateName());
                this.template.modifyCloudTemplate(request);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgModifyTemplateResult);
            } else {
                return;
            }
        }
    }
}

