/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.base.ui.views.actions;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.azure.base.ui.dialogs.CreateInstanceDialog;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceRequest;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudInstanceBackup;
import com.clustercontrol.cloud.resources.Tag;
import com.clustercontrol.cloud.ui.views.InstanceBackupsView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.AzureCreateInstanceRequest;
import com.clustercontrol.ws.azure.AzureImage;
import com.clustercontrol.ws.azure.NodeDetail;
import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class RestoreInstanceAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgRestoreInstanceConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.instance", "word.restore"});
    private String msgRestoreInstanceResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.instance", "word.restore"});

    protected void invoke(IAction action) throws InvocationException {
        CreateInstanceDialog.Model m;
        CreateInstanceDialog dialog = new CreateInstanceDialog(this.viewPart.getSite().getShell());
        ICloudInstanceBackup backup = (ICloudInstanceBackup)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        CloudResourceProviderImpl provider = new CloudResourceProviderImpl(backup.getAccountResourceId());
        InstanceBackupsView view = (InstanceBackupsView)this.viewPart;
        IAccountResource.IRegion region = view.getActiveRegion();
        ICloudComputeService service = (ICloudComputeService)region.getCloudService(ICloudComputeService.class);
        if (region != null) {
            m = new CreateInstanceDialog.Model();
            m.setFacilityId(backup.getBackupedData().getFacilityId());
            m.setFacilityName(backup.getBackupedData().getFacilityName());
            m.setNodeName(backup.getBackupedData().getNodeName());
            m.setReplaceNode(true);
            m.setDescription(backup.getDescription());
            AzureImage azureIMG = new AzureImage();
            azureIMG.setImageId(backup.getInstanceBackupId());
            azureIMG.setDescription(backup.getDescription());
            azureIMG.setOStype(backup.getPlatform());
            azureIMG.setName(backup.getInstanceBackupId());
            m.setAzureImage(azureIMG);
            m.setIsRestore(true);
            dialog.setInput(m);
        }
        dialog.setCurrentRegion(region.getRegion());
        dialog.setCloudInfoProvider(provider);
        dialog.setupCloudService(provider.getAvailabilityZones(region.getRegion()));
        dialog.setBehavior(new CreateInstanceDialog.DialogBehavior(){

            @Override
            public void setupFacilityId(Text facilityId) {
                facilityId.setText(this.input.getFacilityId());
            }

            @Override
            public void setupFacilityName(Text facilityName) {
                if (this.input.getFacilityName() != null) {
                    facilityName.setText(this.input.getFacilityName());
                }
            }

            @Override
            public void setupReplaceNode(Button btnReplaceNode) {
                btnReplaceNode.setSelection(true);
            }

            @Override
            public void setupDescription(Text description) {
                if (this.input.getDescription() != null) {
                    description.setText(this.input.getDescription());
                }
            }

            @Override
            public void setupNodeName(Text nodeName) {
                nodeName.setText(this.input.getNodeName());
            }

            @Override
            public void setupTemplate(Button useTemplate, Combo template, Button editArgument) {
                useTemplate.setEnabled(false);
                template.setEnabled(false);
                editArgument.setEnabled(false);
            }
        });
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgRestoreInstanceConfirm)) {
                m = dialog.getOutput();
                IAccountResource.IRegion r = service.getRegion();
                AzureCreateInstanceRequest azureRequest = new AzureCreateInstanceRequest();
                CreateCloudInstanceRequest cloudRequest = new CreateCloudInstanceRequest();
                NodeDetail nodeDetail = new NodeDetail();
                nodeDetail.setFacilityId(dialog.getOutput().getFacilityId());
                nodeDetail.setFacilityName(dialog.getOutput().getFacilityName());
                nodeDetail.setReplaceNode(dialog.getOutput().getReplaceNode());
                nodeDetail.setDescription(dialog.getOutput().getDescription());
                nodeDetail.setNodeName(dialog.getOutput().getNodeName());
                azureRequest.setNodeDetail(nodeDetail);
                azureRequest.setCloudServiceName(dialog.getOutput().getCloudServiceName());
                azureRequest.setStorageAccountName(dialog.getOutput().getStorageAccountName());
                azureRequest.setContainerName(dialog.getOutput().getContainerName());
                azureRequest.setSize(dialog.getOutput().getSize());
                azureRequest.setAccountName(dialog.getOutput().getNewUserName());
                if (dialog.getOutput().getPassword().equals(dialog.getOutput().getRePassword())) {
                    azureRequest.setPassWord(dialog.getOutput().getPassword());
                }
                azureRequest.setImage(dialog.getOutput().getAzureImage());
                azureRequest.setImageId(dialog.getOutput().getAzureImage().getName());
                azureRequest.getEndPoint().addAll(dialog.getOutput().getEndPoint());
                azureRequest.setAvailabilitySet(dialog.getOutput().getIsAvailabilitySet());
                azureRequest.setAvailabilitySetName(dialog.getOutput().getAvailabilitySetNmae());
                cloudRequest.setFacilityId(dialog.getOutput().getFacilityId());
                cloudRequest.setFacilityName(dialog.getOutput().getFacilityName());
                cloudRequest.setDescription(dialog.getOutput().getDescription());
                cloudRequest.setImageId(dialog.getOutput().getAzureImage().getImageId());
                cloudRequest.setNodeName(dialog.getOutput().getNodeName());
                cloudRequest.setReplaceNode(dialog.getOutput().getReplaceNode());
                cloudRequest.setZone(dialog.getOutput().getCloudServiceName());
                ArrayList<Tag> tags = new ArrayList<Tag>();
                Tag Tag_platform = new Tag();
                Tag_platform.name = "PlatForm";
                Tag_platform.value = dialog.getOutput().getAzureImage().getOStype();
                tags.add(Tag_platform);
                Tag Tag_NodeName = new Tag();
                Tag_NodeName.name = "NodeName";
                Tag_NodeName.value = dialog.getOutput().getNodeName();
                tags.add(Tag_NodeName);
                cloudRequest.setTags(tags);
                ((ICloudComputeService)r.getAccountResource().getRegion(m.getRegionName()).getCloudService(ICloudComputeService.class)).getInstanceManager().createCloudInstance(cloudRequest);
                provider.createInstance(region.getRegion(), azureRequest);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgRestoreInstanceResult);
                this.viewPart.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FacilityTree.refresh();
                    }
                });
            } else {
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        ICloudInstanceBackup backup = (ICloudInstanceBackup)((IStructuredSelection)selection).getFirstElement();
        if (backup == null || backup.getRestoreStatus() == null || backup.getRestoreStatus().equals(ICloudInstanceBackup.RestoreStatus.unavailable.name())) {
            action.setEnabled(false);
        }
    }
}

