/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.base.ui.views.actions;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.azure.base.ui.dialogs.RestoreStorageDialog;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudStorageBackup;
import com.clustercontrol.cloud.ui.views.StorageBackupsView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.SnapShotInfo;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Combo;

public class RestoreStorageAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgRestoreStorageConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.storage", "word.restore"});
    private String msgRestoreStorageResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.storage", "word.restore"});

    protected void invoke(IAction action) throws InvocationException {
        final StorageBackupsView view = (StorageBackupsView)this.viewPart;
        IAccountResource.IRegion region = view.getActiveRegion();
        ICloudStorageBackup backup = (ICloudStorageBackup)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        if (region == null) {
            assert (view.getCurrentAccountResource().getRegions().length > 0);
            region = view.getCurrentAccountResource().getRegions()[0];
        }
        CloudResourceProviderImpl provider = new CloudResourceProviderImpl(region.getAccountResource().getAccountResourceId());
        RestoreStorageDialog dialog = new RestoreStorageDialog(this.viewPart.getSite().getShell());
        SnapShotInfo ssinfo = new SnapShotInfo();
        ssinfo = provider.getSnapShotInfo(region.getRegion(), backup.getStorageBackupId(), backup.getStorageId());
        dialog.setCloudInfoProvider(provider);
        dialog.setSnapShotInfo(ssinfo);
        dialog.setBehavior(new RestoreStorageDialog.DialogBehavior(){

            @Override
            public void setupRegion(Combo cmbRegion) {
                super.setupRegion(cmbRegion);
                if (view != null && view.getActiveRegion() != null && cmbRegion.indexOf(view.getActiveRegion().getRegionName()) != -1) {
                    cmbRegion.select(cmbRegion.indexOf(view.getActiveRegion().getRegionName()));
                } else if (cmbRegion.getItemCount() > 0) {
                    cmbRegion.select(0);
                }
            }
        });
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgRestoreStorageConfirm)) {
                RestoreStorageDialog.DialogData output = dialog.getOutput();
                output.setSourceDiskName(backup.getStorageId());
                output.setSnapShotInfo(ssinfo);
                provider.restoreStorage(region.getRegion(), output);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgRestoreStorageResult);
            } else {
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        ICloudStorageBackup backup = (ICloudStorageBackup)((IStructuredSelection)selection).getFirstElement();
        if (backup == null || backup.getRestoreStatus() == null || backup.getRestoreStatus().equals(ICloudStorageBackup.RestoreStatus.unavailable.name())) {
            action.setEnabled(false);
        }
    }
}

