
package com.clustercontrol.ws.azure;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.Action;
import javax.xml.ws.FaultAction;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.2.7-b01 
 * Generated source version: 2.2
 * 
 */
@WebService(name = "AzureOptionEndpoint", targetNamespace = "http://azure.ws.clustercontrol.com")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface AzureOptionEndpoint {


    /**
     * 
     * @param region
     * @param request
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.azure.Instance
     * @throws InvalidUserPass_Exception
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "createInstance", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.CreateInstance")
    @ResponseWrapper(localName = "createInstanceResponse", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.CreateInstanceResponse")
    @Action(input = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/createInstanceRequest", output = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/createInstanceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/createInstance/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/createInstance/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/createInstance/Fault/InvalidRole")
    })
    public Instance createInstance(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "request", targetNamespace = "")
        AzureCreateInstanceRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param cloudServiceName
     * @param roleId
     * @return
     *     returns java.lang.String
     * @throws InvalidUserPass_Exception
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getRegionByCloudService", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.GetRegionByCloudService")
    @ResponseWrapper(localName = "getRegionByCloudServiceResponse", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.GetRegionByCloudServiceResponse")
    @Action(input = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getRegionByCloudServiceRequest", output = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getRegionByCloudServiceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getRegionByCloudService/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getRegionByCloudService/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getRegionByCloudService/Fault/InvalidRole")
    })
    public String getRegionByCloudService(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "cloudServiceName", targetNamespace = "")
        String cloudServiceName)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param roleId
     * @return
     *     returns java.util.List<java.lang.String>
     * @throws InvalidUserPass_Exception
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getStorageAccountByRegion", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.GetStorageAccountByRegion")
    @ResponseWrapper(localName = "getStorageAccountByRegionResponse", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.GetStorageAccountByRegionResponse")
    @Action(input = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getStorageAccountByRegionRequest", output = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getStorageAccountByRegionResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getStorageAccountByRegion/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getStorageAccountByRegion/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getStorageAccountByRegion/Fault/InvalidRole")
    })
    public List<String> getStorageAccountByRegion(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param arg3
     * @param arg2
     * @param arg0
     * @throws InvalidUserPass_Exception
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "detachStorage", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.DetachStorage")
    @ResponseWrapper(localName = "detachStorageResponse", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.DetachStorageResponse")
    @Action(input = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/detachStorageRequest", output = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/detachStorageResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/detachStorage/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/detachStorage/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/detachStorage/Fault/InvalidRole")
    })
    public void detachStorage(
        @WebParam(name = "arg0", targetNamespace = "")
        String arg0,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "arg2", targetNamespace = "")
        String arg2,
        @WebParam(name = "arg3", targetNamespace = "")
        String arg3)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param cloudServiceName
     * @param roleId
     * @return
     *     returns java.util.List<com.clustercontrol.ws.azure.InstanceInfo>
     * @throws InvalidUserPass_Exception
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getInstanceByCloudService", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.GetInstanceByCloudService")
    @ResponseWrapper(localName = "getInstanceByCloudServiceResponse", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.GetInstanceByCloudServiceResponse")
    @Action(input = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getInstanceByCloudServiceRequest", output = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getInstanceByCloudServiceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getInstanceByCloudService/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getInstanceByCloudService/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getInstanceByCloudService/Fault/InvalidRole")
    })
    public List<InstanceInfo> getInstanceByCloudService(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "cloudServiceName", targetNamespace = "")
        String cloudServiceName)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param snapShotId
     * @param storageId
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.azure.SnapShotInfo
     * @throws InvalidUserPass_Exception
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getSnapShotInfo", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.GetSnapShotInfo")
    @ResponseWrapper(localName = "getSnapShotInfoResponse", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.GetSnapShotInfoResponse")
    @Action(input = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getSnapShotInfoRequest", output = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getSnapShotInfoResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getSnapShotInfo/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getSnapShotInfo/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getSnapShotInfo/Fault/InvalidRole")
    })
    public SnapShotInfo getSnapShotInfo(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "snapShotId", targetNamespace = "")
        String snapShotId,
        @WebParam(name = "storageId", targetNamespace = "")
        String storageId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param storageAccountName
     * @param roleId
     * @return
     *     returns java.util.List<java.lang.String>
     * @throws InvalidUserPass_Exception
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getContainerByStorageAccount", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.GetContainerByStorageAccount")
    @ResponseWrapper(localName = "getContainerByStorageAccountResponse", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.GetContainerByStorageAccountResponse")
    @Action(input = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getContainerByStorageAccountRequest", output = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getContainerByStorageAccountResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getContainerByStorageAccount/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getContainerByStorageAccount/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getContainerByStorageAccount/Fault/InvalidRole")
    })
    public List<String> getContainerByStorageAccount(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "storageAccountName", targetNamespace = "")
        String storageAccountName)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param storageBackupURL
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "deleteStorageBackup", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.DeleteStorageBackup")
    @ResponseWrapper(localName = "deleteStorageBackupResponse", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.DeleteStorageBackupResponse")
    @Action(input = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/deleteStorageBackupRequest", output = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/deleteStorageBackupResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/deleteStorageBackup/Fault/CloudManagerFault")
    })
    public void deleteStorageBackup(
        @WebParam(name = "storageBackupURL", targetNamespace = "")
        String storageBackupURL)
        throws CloudManagerFault_Exception
    ;

    /**
     * 
     * @param region
     * @param azureRestoreStorageRequest
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.azure.CloudStorage
     * @throws InvalidUserPass_Exception
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "restoreStorage", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.RestoreStorage")
    @ResponseWrapper(localName = "restoreStorageResponse", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.RestoreStorageResponse")
    @Action(input = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/restoreStorageRequest", output = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/restoreStorageResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/restoreStorage/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/restoreStorage/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/restoreStorage/Fault/InvalidRole")
    })
    public CloudStorage restoreStorage(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "AzureRestoreStorageRequest", targetNamespace = "")
        AzureRestoreStorageRequest azureRestoreStorageRequest)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param filter
     * @param roleId
     * @return
     *     returns java.util.List<com.clustercontrol.ws.azure.AzureImage>
     * @throws InvalidUserPass_Exception
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getImagesWithFilter", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.GetImagesWithFilter")
    @ResponseWrapper(localName = "getImagesWithFilterResponse", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.GetImagesWithFilterResponse")
    @Action(input = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getImagesWithFilterRequest", output = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getImagesWithFilterResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getImagesWithFilter/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getImagesWithFilter/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getImagesWithFilter/Fault/InvalidRole")
    })
    public List<AzureImage> getImagesWithFilter(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "filter", targetNamespace = "")
        String filter)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param request
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.azure.CloudStorage
     * @throws InvalidUserPass_Exception
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "addStorage", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.AddStorage")
    @ResponseWrapper(localName = "addStorageResponse", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.AddStorageResponse")
    @Action(input = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/addStorageRequest", output = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/addStorageResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/addStorage/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/addStorage/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/addStorage/Fault/InvalidRole")
    })
    public CloudStorage addStorage(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "request", targetNamespace = "")
        AzureCreateStorageRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param azureCreateStorageRequest
     * @param arg1
     * @param arg0
     * @param storageId
     * @throws InvalidUserPass_Exception
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "atachStorage", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.AtachStorage")
    @ResponseWrapper(localName = "atachStorageResponse", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.AtachStorageResponse")
    @Action(input = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/atachStorageRequest", output = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/atachStorageResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/atachStorage/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/atachStorage/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/atachStorage/Fault/InvalidRole")
    })
    public void atachStorage(
        @WebParam(name = "arg0", targetNamespace = "")
        String arg0,
        @WebParam(name = "arg1", targetNamespace = "")
        String arg1,
        @WebParam(name = "storageId", targetNamespace = "")
        String storageId,
        @WebParam(name = "AzureCreateStorageRequest", targetNamespace = "")
        AzureCreateStorageRequest azureCreateStorageRequest)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param cloudServiceName
     * @param roleId
     * @return
     *     returns java.util.List<java.lang.String>
     * @throws InvalidUserPass_Exception
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getStorageAccountByCloudService", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.GetStorageAccountByCloudService")
    @ResponseWrapper(localName = "getStorageAccountByCloudServiceResponse", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.GetStorageAccountByCloudServiceResponse")
    @Action(input = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getStorageAccountByCloudServiceRequest", output = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getStorageAccountByCloudServiceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getStorageAccountByCloudService/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getStorageAccountByCloudService/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getStorageAccountByCloudService/Fault/InvalidRole")
    })
    public List<String> getStorageAccountByCloudService(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "cloudServiceName", targetNamespace = "")
        String cloudServiceName)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param arg2
     * @param arg0
     * @return
     *     returns java.util.List<com.clustercontrol.ws.azure.DataVirtualHardDisks>
     * @throws InvalidUserPass_Exception
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getAttacheableDataVirtualHardDisk", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.GetAttacheableDataVirtualHardDisk")
    @ResponseWrapper(localName = "getAttacheableDataVirtualHardDiskResponse", targetNamespace = "http://azure.ws.clustercontrol.com", className = "com.clustercontrol.ws.azure.GetAttacheableDataVirtualHardDiskResponse")
    @Action(input = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getAttacheableDataVirtualHardDiskRequest", output = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getAttacheableDataVirtualHardDiskResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getAttacheableDataVirtualHardDisk/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getAttacheableDataVirtualHardDisk/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://azure.ws.clustercontrol.com/AzureOptionEndpoint/getAttacheableDataVirtualHardDisk/Fault/InvalidRole")
    })
    public List<DataVirtualHardDisks> getAttacheableDataVirtualHardDisk(
        @WebParam(name = "arg0", targetNamespace = "")
        String arg0,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "arg2", targetNamespace = "")
        String arg2)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

}
