/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.azure.base.resources;

import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.ws.azure.EndPoint;

public class EndPointInfo {

	private static MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
    public final static String RDP = messages.getString("word.endpoint_default_name_rdp");
    public final static String PS = messages.getString("word.endpoint_default_name_ps");
    public final static String SSH = messages.getString("word.endpoint_default_name_ssh");
    
    public final static String tcp = messages.getString("word.tcp");
    public final static String udp = messages.getString("word.udp");
    
    public final static String RDP_PORT = messages.getString("word.endpoint_default_port_rdp");
    public final static String PS_PORT = messages.getString("word.endpoint_default_port_ps");
    public final static String SSH_PORT = messages.getString("word.endpoint_default_port_ssh");
    public final static String AUTO_GET_PORT = messages.getString("word.port_auto");
    
    public List<EndPoint> getWindowsDefaultEndPoint(){
    	EndPoint ep_rdp = new EndPoint();
    	ep_rdp.setName(RDP);
    	ep_rdp.setProtocol(tcp);
    	ep_rdp.setPublicPort(null);
    	ep_rdp.setPrivatePort(Integer.parseInt(RDP_PORT));
    	
    	EndPoint ep_ps = new EndPoint();
    	ep_ps.setName(PS);
    	ep_ps.setProtocol(tcp);
    	ep_ps.setPublicPort(null);
    	ep_ps.setPrivatePort(Integer.parseInt(PS_PORT));
    	
    	List<EndPoint> endPoints = new ArrayList<>();
    	endPoints.add(ep_rdp);
    	endPoints.add(ep_ps);
    	return endPoints;
    }
    
    public List<EndPoint> getLinuxDefaultEndPoint(){
    	EndPoint ep_ssh = new EndPoint();
    	ep_ssh.setName(SSH);
    	ep_ssh.setProtocol(tcp);
    	ep_ssh.setPublicPort(null);
    	ep_ssh.setPrivatePort(Integer.parseInt(SSH_PORT));
    	
    	List<EndPoint> endPoints = new ArrayList<>();
    	endPoints.add(ep_ssh);
    	return endPoints;
    }

}