/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.azure.base.ui.dialogs;

import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.ws.azure.DataVirtualHardDisks;
import com.clustercontrol.ws.azure.InstanceInfo;
import com.clustercontrol.ws.azure.VirtualHardDiskHostCaching;

public class AttachStorageFromStorageDialog extends Dialog {
	public static class VolumeProvider {
		private VolumeContentProvider vcp;
		private VolumeLabelProvider vlp;

		public VolumeProvider(){
			this.vcp = new VolumeContentProvider();
			this.vlp = new VolumeLabelProvider();
		}

		public class VolumeContentProvider implements IStructuredContentProvider {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((java.util.List<?>)inputElement).toArray();
			}
			@Override
			public void dispose() {
			}
			@Override
			public void inputChanged(Viewer viewer,	Object oldInput, Object newInput) {
			}
		}

		public class VolumeLabelProvider extends LabelProvider implements ITableLabelProvider {
			@Override
			public String getColumnText(Object element, int columnIndex) {
				ICloudStorage storage = (ICloudStorage)element;
				switch(columnIndex) {
					case 0:
						return storage.getStorageId();
					case 1:
						return storage.getStorageAttachment() != null ? storage.getStorageAttachment().getDevice() : "";
					case 2:
						return storage.getSnapshotId() != null ? storage.getSnapshotId(): "";
					case 3:
						return storage.getSize() != null ? String.valueOf(storage.getSize()): "";
					case 4:
						return storage.getFlavor();
					}
				return null;
			}
			@Override
			public Image getColumnImage(Object element, int columnIndex) {
				return null;
			}
		}

		public VolumeContentProvider getVolumeContentProvider(){
			return this.vcp;
		}

		public VolumeLabelProvider getVolumeLabelProvider(){
			return this.vlp;
		}
	}

	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");

	private String strDiscName = messages.getString("word.disc_name");
	private String instanceName = messages.getString("word.instance_name");
	private String strLun = messages.getString("word.lun");
	private String strHostCacheConfig = messages.getString("word.host_cache_config");
	private String strHostCacheNone = messages.getString("word.host_cache_none");
	private String strHostCacheReadOnly = messages.getString("word.host_cache_read_only");
	private String strHostCacheReadWrite = messages.getString("word.host_cache_read_write");
	private String strOs = messages.getString("word.os");
	private String strSubscription = messages.getString("word.subscription");
	private String strSpot = messages.getString("word.spot");
	private String strAttachStorageDialog = messages.getString("caption.attach_storage_dialog");

	private Text txtdiscName;
	private Combo cmblun;
	private Button btnHostCacheNone;
	private Button btnHostCacheReadOnly;
	private Button btnHostCacheReadWrite;
	private Table table;

	private ICloudStorage storage;
	private String instanceId;
	private String deviceName;
	
	List<String> luns;
	String subscriptionId;
	String uri;
	String cloudService;
	List<DataVirtualHardDisks> dataVirtualHardDisks;
	List<InstanceInfo> instancesInfo;
	int diskSize;
	VirtualHardDiskHostCaching hostCache;
	Integer lun;

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public AttachStorageFromStorageDialog(Shell parentShell, ICloudStorage storage) {
		super(parentShell);
		this.storage = storage;
	}

	public String getInstanceId(){
		return instanceId;
	}

	public String getDeviceName(){
		return deviceName;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {

		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);

		Label lblDiscName = new Label(container, SWT.NONE);
		lblDiscName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblDiscName.setText(strDiscName);

		txtdiscName = new Text(container, SWT.BORDER | SWT.READ_ONLY);
		txtdiscName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		txtdiscName.setText(storage.getStorageId());

		Label lblLun = new Label(container, SWT.NONE);
		lblLun.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblLun.setText(strLun);

		//storage.update();
		cmblun = new Combo(container, SWT.READ_ONLY);
		cmblun.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		Group grpHostCache = new Group(container,SWT.NONE);
		GridLayout gl_hostCache = new GridLayout(3, false);
		grpHostCache.setLayout(gl_hostCache);
		GridData gd_hostCache = new GridData(SWT.FILL, SWT.CENTER, true, false, 4, 1);
		gd_hostCache.horizontalSpan=4;
		grpHostCache.setLayoutData(gd_hostCache);
		grpHostCache.setText(strHostCacheConfig);

		btnHostCacheNone = new Button(grpHostCache, SWT.RADIO);
		btnHostCacheNone.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnHostCacheNone.setSelection(true);
		btnHostCacheNone.setText(strHostCacheNone);

		btnHostCacheReadOnly = new Button(grpHostCache, SWT.RADIO);
		btnHostCacheReadOnly.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnHostCacheReadOnly.setText(strHostCacheReadOnly);

		btnHostCacheReadWrite = new Button(grpHostCache, SWT.RADIO);
		btnHostCacheReadWrite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnHostCacheReadWrite.setText(strHostCacheReadWrite);

		table = new Table(container, SWT.BORDER | SWT.FULL_SELECTION);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));

		TableColumn tblclmnInstance = new TableColumn(table, SWT.NONE);
		tblclmnInstance.setWidth(160);
		tblclmnInstance.setText(instanceName);

		TableColumn tableColumnOS = new TableColumn(table, SWT.NONE);
		tableColumnOS.setWidth(100);
		tableColumnOS.setText(strOs);

		TableColumn tableColumnSubscription = new TableColumn(table, SWT.NONE);
		tableColumnSubscription.setWidth(160);
		tableColumnSubscription.setText(strSubscription);

		TableColumn tableColumnSpot = new TableColumn(table, SWT.NONE);
		tableColumnSpot.setWidth(160);
		tableColumnSpot.setText(strSpot);

		for(InstanceInfo instanceInfo:instancesInfo){
			TableItem item = new TableItem(table,SWT.NULL);
			String[] data ={instanceInfo.getInstanceName(),
							instanceInfo.getOSType(),
							subscriptionId,
							this.cloudService};
			item.setText(data);
		}
		table.setSelection(0);
		
		table.addSelectionListener(new SelectionListener(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				cmblun.removeAll();
				Table btable = (Table)e.widget;
				String item = btable.getItem(btable.getSelectionIndex()).getText();
				for(InstanceInfo ii:instancesInfo){
					if(ii.getInstanceName().equals(item)){
						for(int i=0;i<=15;i++){
							if(!ii.getAttachedLun().contains(i)){
								cmblun.add(Integer.toString(i));
							}
						}
					}
				}
				cmblun.select(0);
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
			}
		});
		return area;
	}


	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}

	@Override
	protected void okPressed() {

		instanceId = table.getItem(table.getSelectionIndex()).getText(0);
		deviceName = "";
		lun = Integer.parseInt(cmblun.getText());
		if(btnHostCacheReadOnly.getSelection()){
			hostCache = VirtualHardDiskHostCaching.READ_ONLY;
		}else if(btnHostCacheReadWrite.getSelection()){
			hostCache = VirtualHardDiskHostCaching.READ_WRITE;
		}else{
			hostCache = VirtualHardDiskHostCaching.NONE;
		}
		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strAttachStorageDialog);
	}

	public String getSubscriptionId(){
		return subscriptionId;
	}

	public void setSubscriptionId(String subscriptionId){
		this.subscriptionId = subscriptionId;
	}

	public String getUri(){
		return uri;
	}

	public void setUri(String uri){
		this.uri = uri;
	}

	public List<DataVirtualHardDisks> getDataVirtualHardDisks(){
		return dataVirtualHardDisks;
	}

	public void setDataVirtualHardDisks(List<DataVirtualHardDisks> dataVirtualHardDisks){
		this.dataVirtualHardDisks = dataVirtualHardDisks;
	}
	
	public List<InstanceInfo> getInstanceInfo(){
		return this.instancesInfo;
	}

	public void setInstanceInfo(List<InstanceInfo> instancesInfo){
		this.instancesInfo = instancesInfo;
	}
	
	public int getDiskSize(){
		return diskSize;
	}

	public void setDiskSize(int diskSize){
		this.diskSize = diskSize;
	}
	
	public String getCloudService(){
		return cloudService;
	}

	public void setCloudService(String cloudService){
		this.cloudService = cloudService;
	}
	
	public VirtualHardDiskHostCaching getHostCaching(){
		return this.hostCache;
	}
	
	public void setHostCaching(VirtualHardDiskHostCaching hostCache){
		this.hostCache=hostCache;
	}
	
	public Integer getLun(){
		return lun;
	}

	public void setLun(Integer lun){
		this.lun = lun;
	}
	
}
