/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.azure.base.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.presenter.CreateCloudTemplateRequest;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.AzureImage;

public class CreateTemplateDialog extends Dialog {
	
	public interface IDialogBehavior{
		void setupRegion(Combo region);
		void setupTemplateId(Text templateId);
		void setupTemplateName(Text templateName);
		void setupAmi(Text ami, Button selectAmi);
		void setupLaunchJobId(Combo launchJobId);
		void setupStartJobId(Combo startJobId);
		void setupStopJobId(Combo stopJobId);
	}
	
	public static class DialogBehavior implements IDialogBehavior{
		public void setupRegion(Combo region){};
		public void setupTemplateId(Text templateId){};
		public void setupTemplateName(Text templateName){};
		public void setupAmi(Text ami, Button selectAmi){};
		public void setupLaunchJobId(Combo launchJobId){};
		public void setupStartJobId(Combo startJobId){};
		public void setupStopJobId(Combo stopJobId){};
	}

	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String strSeparator = messages.getString("caption.title_separator");
	private String strTemplateName = messages.getString("word.template_name");
	private String strLaunchJobId = messages.getString("word.launch_job_id");
	private String strStartJobId = messages.getString("word.start_job_id");
	private String strStopJobId = messages.getString("word.stop_job_id");
	private String strRegion = messages.getString("word.region");
	private String strImage = messages.getString("word.image");
	private String strRefer = messages.getString("word.refer");
	private String strTemplate = messages.getString("word.template");
	private String strCreateTemplateDialog = messages.getString("caption.create_template_dialog");
	private String msgMustFullyInput = messages.getString("message.must_fully_input");
	private String msgEmptyRegion = messages.getString("message.empty_region");

	
	private Shell shell;

	private Combo region;
	private Text templateId;
	private Text templateName;
	private Text vmi;
	private Combo launchJobId;
	private Combo startJobId;
	private Combo stopJobId;
	
	private CloudResourceProvider provider;

	private IDialogBehavior behavior = new DialogBehavior();

	private CreateCloudTemplateRequest output = new CreateCloudTemplateRequest();
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateTemplateDialog(Shell parentShell) {
		super(parentShell);
		this.shell = parentShell;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.FILL);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(3, false);
		gl_container.verticalSpacing = 15;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(SWT.FILL, SWT.FILL, true, false);
		gd_container.verticalAlignment = SWT.FILL;
		gd_container.horizontalAlignment = SWT.FILL;
		container.setLayoutData(gd_container);
				
		Label lblRegion = new Label(container, SWT.RIGHT);
		lblRegion.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblRegion.setText(strRegion + strSeparator);

		region = new Combo(container, SWT.READ_ONLY);
		region.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));

		Label lblTemplateId = new Label(container, SWT.RIGHT);
		lblTemplateId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblTemplateId.setText(strTemplate + strSeparator);

		templateId = new Text(container, SWT.BORDER);
		templateId.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
				
		Label lblTemplateName = new Label(container, SWT.RIGHT);
		lblTemplateName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblTemplateName.setText(strTemplateName + strSeparator);
		
		templateName = new Text(container, SWT.BORDER);
		templateName.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
	
		Label lblVmi = new Label(container, SWT.RIGHT);
		lblVmi.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblVmi.setText(strImage + strSeparator);

		vmi = new Text(container, SWT.BORDER | SWT.READ_ONLY);
		vmi.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		Button btnSelectVMI = new Button(container, SWT.NONE);
		btnSelectVMI.setText(strRefer);
		btnSelectVMI.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, true, 1, 1));

		Label lblLaunchJobId = new Label(container, SWT.RIGHT);
		lblLaunchJobId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblLaunchJobId.setText(strLaunchJobId + strSeparator);

		launchJobId = new Combo(container, SWT.READ_ONLY);
		GridData gd_launchJobId = new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1);
		gd_launchJobId.widthHint = 100;
		launchJobId.setLayoutData(gd_launchJobId);

		Label lblStartJobId = new Label(container, SWT.RIGHT);
		lblStartJobId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblStartJobId.setText(strStartJobId + strSeparator);

		startJobId = new Combo(container, SWT.READ_ONLY);
		GridData gd_startJobId = new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1);
		gd_startJobId.widthHint = 100;
		startJobId.setLayoutData(gd_startJobId);

		Label lblStopJobId = new Label(container, SWT.RIGHT);
		lblStopJobId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblStopJobId.setText(strStopJobId + strSeparator);

		stopJobId = new Combo(container, SWT.READ_ONLY);
		GridData gd_stopJobId = new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1);
		gd_stopJobId.widthHint = 100;
		stopJobId.setLayoutData(gd_stopJobId);

		behavior.setupRegion(region);
		behavior.setupTemplateId(templateId);
		behavior.setupTemplateName(templateName);
		behavior.setupAmi(vmi, btnSelectVMI);
		behavior.setupLaunchJobId(launchJobId);
		behavior.setupStartJobId(startJobId);
		behavior.setupStopJobId(stopJobId);

		region.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				vmi.setText("");
				vmi.setData(null);
			}
		});

		btnSelectVMI.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				SelectVMIDialog dialog = new SelectVMIDialog(shell);
				if(region.getText()!=""){
					dialog.setCloudInfoProvider(provider);
					dialog.setRegion((String)region.getData(region.getText()));
					dialog.open();
				}else{
					MessageDialog.openError(null,
							Messages.getString("failed"),
							msgEmptyRegion);
					return;
				}

				if (dialog.getReturnCode() == Window.OK) {
					AzureImage image = dialog.getOutput();
					vmi.setText("("+image.getImageId()+") "+image.getName());
					output.setImageId(image.getImageId());
				}
			}
		});

		ControlUtil.setRequired(new Control[]{templateId, templateName, vmi});

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}

	@Override
	protected void okPressed() {
		if(templateId.getText() == ""
			|| templateName.getText() == ""
			|| region.getText() == ""
			|| vmi.getText() == ""
		){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					msgMustFullyInput);
			return;
		}
		
		output.setRegion((String)region.getData(region.getText()));
		output.setTemplateId(templateId.getText());
		output.setTemplateName(templateName.getText().equals("")? null : templateName.getText());
		output.setLaunchJobId(launchJobId.getText().equals("")? null : (String)launchJobId.getData(launchJobId.getText()));
		output.setStartJobId(startJobId.getText().equals("")? null : (String)startJobId.getData(startJobId.getText()));
		output.setStopJobId(stopJobId.getText().equals("")? null : (String)stopJobId.getData(stopJobId.getText()));

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strCreateTemplateDialog);
	}

	public CreateCloudTemplateRequest getOutput() {
		return output;
	}

	public void setCloudInfoProvider(CloudResourceProvider provider) {
		this.provider = provider;
	}
	
	public void setBehavior(IDialogBehavior behavior){
		this.behavior = behavior;
	}
}
