/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.azure.base.ui.dialogs;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.DataVirtualHardDisk;
import com.clustercontrol.ws.azure.InstanceInfo;

public class DetachStorageFromInstanceDialog extends Dialog {
	private MessageManagerExt messages =MessageManagerExt.getInstance("messages");

	private String strInstance = messages.getString("word.instance");
	private String strLun = messages.getString("word.lun");
	private String strDiscName = messages.getString("word.disc_name");
	private String strOs = messages.getString("word.os");
	private String strHostCache = messages.getString("word.host_cache");
	private String strSubscription = messages.getString("word.subscription");
	private String strSpot = messages.getString("word.spot");
	private String strDetachStorageDialog = messages.getString("caption.detach_storage_dialog");
	private String msgMustFullyInput = messages.getString("message.must_fully_input");



	private ICloudInstance instance;
	private java.util.List<ICloudStorage> volumes = new ArrayList<ICloudStorage>();
	private Table table;
	private Text instanceName;
	
	private String instanceID;
	private String storageID;

	String storageAccountName;
	String subscriptionId;
	InstanceInfo instanceInfo;
	String uri;
	String hostCache;
	String lun;

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public DetachStorageFromInstanceDialog(Shell parentShell, ICloudInstance instance) {
		super(parentShell);
		this.instance = instance;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);

		Label lblInstance = new Label(container, SWT.NONE);
		lblInstance.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblInstance.setText(strInstance);

		instanceName = new Text(container, SWT.BORDER | SWT.READ_ONLY);
		instanceName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		instanceName.setText(instance.getInstanceId());

		table = new Table(container, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));

		TableColumn tblclmnVolumeId = new TableColumn(table, SWT.NONE);
		tblclmnVolumeId.setWidth(105);
		tblclmnVolumeId.setText(strDiscName);

		TableColumn tableColumn_6 = new TableColumn(table, SWT.NONE);
		tableColumn_6.setWidth(70);
		tableColumn_6.setText(strOs);

		TableColumn tableColumn_1 = new TableColumn(table, SWT.NONE);
		tableColumn_1.setWidth(110);
		tableColumn_1.setText(strHostCache);

		TableColumn tableColumn_2 = new TableColumn(table, SWT.NONE);
		tableColumn_2.setWidth(120);
		tableColumn_2.setText(strSubscription);

		TableColumn tableColumn_3 = new TableColumn(table, SWT.NONE);
		tableColumn_3.setWidth(70);
		tableColumn_3.setText(strLun);

		TableColumn tableColumn_4 = new TableColumn(table, SWT.NONE);
		tableColumn_4.setWidth(105);
		tableColumn_4.setText(strSpot);

		
		
		for(DataVirtualHardDisk dvhd:instanceInfo.getDataVirtualHardDisks()){
			/*if(dataVirtualHardDisks.get(i).getHostCaching() != null){
				hostCache = dataVirtualHardDisks.get(i).getHostCaching().toString();
			}
			if(dataVirtualHardDisks.get(i).getHostCaching() != null){
				hostCache = dataVirtualHardDisks.get(i).getHostCaching().toString();
			}
			if(dataVirtualHardDisks.get(i).getLogicalUnitNumber() != null){
				lun = dataVirtualHardDisks.get(i).getLogicalUnitNumber().toString();
			}
			if(dataVirtualHardDisks.get(i).getMediaLink() != null){
				uri = dataVirtualHardDisks.get(i).getMediaLink();
			}*/
			
			String[] data ={dvhd.getName(),
							"Data",
							dvhd.getHostCaching()!=null?dvhd.getHostCaching().toString():"",
							subscriptionId,
							dvhd.getLogicalUnitNumber()==null?"":dvhd.getLogicalUnitNumber().toString(),
							dvhd.getMediaLink()};
			TableItem item = new TableItem(table,SWT.NULL);
			item.setText(data);
		}
		table.setSelection(0);

		//tableViewer = new TableViewer(table);
		//VolumeProvider vp = new VolumeProvider();
		//tableViewer.setContentProvider(vp.getVolumeContentProvider());
		//instance.getCloudInstanceManager().getCloudComputeService().getStorageManager().update();
		//List<ICloudStorage> storages = new ArrayList<ICloudStorage>();
		//for (ICloudStorage s: instance.getCloudInstanceManager().getCloudComputeService().getStorageManager().getCloudStorages()) {
		//	for (BlockDeviceMapping d: instance.getBlockDeviceMappings()) {
		//		if (d.getVolumeId().equals(s.getStorageId())) {
		//			storages.add(s);
		//			break;
		//		}
		//	}
		//}
		//tableViewer.setInput(storages);
		//tableViewer.setLabelProvider(vp.getVolumeLabelProvider());
		table.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				volumes.clear();
				for(TableItem ti: table.getSelection()){
					volumes.add((ICloudStorage)ti.getData());
				}
			}
		});
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}

	@Override
	protected void okPressed() {
		if(this.volumes.isEmpty()){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					msgMustFullyInput);
			return;
		}
		
		setInstanceID(instance.getInstanceId());
		setStorageID(table.getItem(table.getSelectionIndex()).getText(0));

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strDetachStorageDialog);
	}

	public static class VolumeProvider {
		private VolumeContentProvider vcp;
		private VolumeLabelProvider vlp;

		public VolumeProvider(){
			this.vcp = new VolumeContentProvider();
			this.vlp = new VolumeLabelProvider();
		}

		public class VolumeContentProvider implements IStructuredContentProvider {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((java.util.List<?>)inputElement).toArray();
			}
			@Override
			public void dispose() {
			}
			@Override
			public void inputChanged(Viewer viewer,	Object oldInput, Object newInput) {
			}
		}

		public class VolumeLabelProvider extends LabelProvider implements ITableLabelProvider {
			@Override
			public String getColumnText(Object element, int columnIndex) {
				ICloudStorage storage = (ICloudStorage)element;
				switch(columnIndex) {
					case 0:
						return storage.getStorageId();
					case 1:
						return storage.getStorageName();
					case 2:
						return storage.getStorageAttachment() != null ? storage.getStorageAttachment().getDevice() : "";
					case 3:
						return storage.getSnapshotId() != null ? storage.getSnapshotId(): "";
					case 4:
						return storage.getSize() != null ? String.valueOf(storage.getSize()): "";
					case 5:
						return storage.getFlavor();
					}
				return null;
			}
			@Override
			public Image getColumnImage(Object element, int columnIndex) {
				return null;
			}
		}

		public VolumeContentProvider getVolumeContentProvider(){
			return this.vcp;
		}

		public VolumeLabelProvider getVolumeLabelProvider(){
			return this.vlp;
		}

	}
	public String getStorageAccountName(){
		return this.storageAccountName;
	}

	public void setStorageAccountName(String storageAccountName){
		this.storageAccountName = storageAccountName;
	}
	public String getSubscriptionId(){
		return subscriptionId;
	}

	public void setSubscriptionId(String subscriptionId){
		this.subscriptionId = subscriptionId;
	}

	public InstanceInfo getDataVirtualHardDisks(){
		return this.instanceInfo;
	}

	public void setDataVirtualHardDisks(InstanceInfo instanceInfo){
		this.instanceInfo = instanceInfo;
	}
	
	public void setInstanceID(String instanceID){
		this.instanceID = instanceID;
	}
	
	public void setStorageID(String storageID){
		this.storageID = storageID;
	}
	
	public String getInstanceID(){
		return this.instanceID;
	}
	
	public String getStorageID(){
		return this.storageID;
	}

}
