/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.cloud.azure.base.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

//import org.apache.commons.logging.Log;
//import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.EndPoint;
import com.clustercontrol.ws.notify.NotifyRelationInfo;

/**
 * クラウド[エンドポイント設定]ダイアログクラス<BR>
 *
 * @version 3.0.0
 * @since 2.0.0
 */
public class RegistEndPointDialog extends CommonDialog {

	// ログ
	//private static Log m_log = LogFactory.getLog( NotifyListDialog.class );

	// 後でpackするためsizeXはダミーの値。
	private final int sizeX = 640;
	private final int sizeY = 450;

	/** 通知一覧 コンポジット。 */
	//private NotifyListComposite notifyList = null;

	/** 追加 ボタン。 */
	private Button buttonAdd = null;

	/** 変更 ボタン。 */
	private Button buttonModify = null;

	/** 削除 ボタン。 */
	private Button buttonDelete = null;

	/** 有効ボタン */
	//private Button buttonValid = null;

	/** 無効ボタン */
	//private Button buttonInvalid = null;

	private Table table;
	private TableItem[] item;
	Boolean endPointFlg;
	private String osType = "dummy";

	private CreateInstanceDialog.Model output;

	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");

	private String strEndPoint = messages.getString("caption.regist_end_point_dialog");
	private String strName = messages.getString("word.name");
	private String strProtcol = messages.getString("word.protocol");
	private String strPublicPort = messages.getString("word.public_port");
	private String strPrivatePort = messages.getString("word.private_port");
	private String strAuto = messages.getString("word.port_auto");
	private String msgMustEndPoint = messages.getString("message.must_select_end_point");
	private String msgMustDeleteEndPoint = messages.getString("message.must_delete_select_end_point");


	/***/
	List<NotifyRelationInfo> notify;
	List<EndPoint> endPoint= new ArrayList<>();
	/**
	 * ダイアログのインスタンスを返します。
	 *
	 * @param parent 親のシェルオブジェクト
	 */
	public RegistEndPointDialog(Shell parent) {
		super(parent);
		setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
	}

	public RegistEndPointDialog(Shell parent, boolean isSelect, int notifyIdType, String ownerRoleId) {

		super(parent);
		setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
	}

	/**
	 * ダイアログの初期サイズを返します。
	 *
	 * @return 初期サイズ
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(sizeX, sizeY);
	}

	/**
	 * ダイアログエリアを生成します。
	 *
	 * @param parent 親のコンポジット
	 *
	 * @see com.clustercontrol.notify.composite.NotifyListComposite
	 */
	@Override
	protected void customizeDialog(Composite parent) {
		Shell shell = this.getShell();

		// タイトル
		shell.setText(strEndPoint);

		// レイアウト
		GridLayout layout = new GridLayout(8, true);
		layout.marginWidth = 10;
		layout.marginHeight = 10;
		layout.numColumns = 8;
		parent.setLayout(layout);

		/*
		 * ログ一覧
		 */

		table = new Table(parent, SWT.BORDER | SWT.FULL_SELECTION);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		//this.notifyList = new NotifyListComposite(parent, SWT.BORDER, isSelect, this.ownerRoleId);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 7;
		gridData.heightHint = SWT.MIN;
		table.setLayoutData(gridData);
		//this.notifyList.setLayoutData(gridData);
		//this.notifyList.setSelectNotify(this.notify);
		//this.notifyList.update();
		// アクセス権限がなく、通知一覧が取得できなかった場合は、本ダイアログを閉じる
		//if(!this.notifyList.isShowFlg()) {
		//	this.close();
		//	return ;
		//}

		TableColumn tableColumn_1 = new TableColumn(table, SWT.NONE);
		tableColumn_1.setWidth(130);
		tableColumn_1.setText(strName);

		TableColumn tableColumn_2 = new TableColumn(table, SWT.NONE);
		tableColumn_2.setWidth(130);
		tableColumn_2.setText(strProtcol);

		TableColumn tableColumn_3 = new TableColumn(table, SWT.NONE);
		tableColumn_3.setWidth(130);
		tableColumn_3.setText(strPublicPort);

		TableColumn tableColumn_4 = new TableColumn(table, SWT.NONE);
		tableColumn_4.setWidth(132);
		tableColumn_4.setText(strPrivatePort);

		endPoint = this.getEndPoint();
		List<EndPoint> availableVolumes = new ArrayList<EndPoint>(endPoint);
		Iterator<EndPoint> itav = availableVolumes.iterator();
		while (itav.hasNext()){
			EndPoint endPoint = itav.next();
			TableItem item = new TableItem(table,SWT.NULL);
			String[] data ={endPoint.getName(),
							endPoint.getProtocol(),
							endPoint.getPublicPort()==null?strAuto:endPoint.getPublicPort().toString(),
							endPoint.getPrivatePort().toString()};
			item.setText(data);
			table.setSelection(0);
		}

		/*
		 * 操作ボタン
		 */

		Composite composite = new Composite(parent, SWT.NONE);
		layout = new GridLayout(1, true);
		layout.numColumns = 1;
		composite.setLayout(layout);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 1;
		composite.setLayoutData(gridData);

		// 追加ボタン
		this.buttonAdd = this
				.createButton(composite, Messages.getString("add"));
		this.buttonAdd.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				CreateEndPointDialog dialog = new CreateEndPointDialog(getParentShell());
				dialog.open();

				if (dialog.getReturnCode() == Window.OK) {
					endPoint = dialog.getEndPoint();
					List<EndPoint> availableVolumes = new ArrayList<EndPoint>(endPoint);
					for(EndPoint endPoint:availableVolumes){
						TableItem item = new TableItem(table,SWT.NULL);
						String[] data ={endPoint.getName(),
										endPoint.getProtocol(),
										endPoint.getPublicPort()==null?strAuto:endPoint.getPublicPort().toString(),
										endPoint.getPrivatePort().toString()};
						item.setText(data);
						table.setSelection(0);
					}
				}
			}
		});

		// 変更ボタン
		@SuppressWarnings("unused") Label dummy = new Label(composite, SWT.NONE);
		this.buttonModify = this.createButton(composite, Messages.getString("modify"));
		this.buttonModify.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {

				//Table table = notifyList.getTableViewer().getTable();
				item = table.getSelection();
				CreateEndPointDialog action = new CreateEndPointDialog(getParentShell());

				if (item != null && item.length>0) {
					//if (action.openDialog(getParentShell(), notifyId, notifyType) ==
					//		IDialogConstants.OK_ID) {
						int selectIndex = table.getSelectionIndex();
						//notifyList.update();

						table.setSelection(selectIndex);
						action.setEndPointName(table.getItem(selectIndex).getText(0));
						action.setProtocol(table.getItem(selectIndex).getText(1));
						action.setPublicPort(table.getItem(selectIndex).getText(2));
						action.setPrivatePort(table.getItem(selectIndex).getText(3));
					//}
					action.open();
				} else{
					MessageDialog.openWarning(
							null,
							Messages.getString("warning"),
							msgMustEndPoint);
				}
				if (action.getReturnCode() == Window.OK) {
					endPoint = action.getEndPoint();
					int selectIndex = table.getSelectionIndex();
					List<EndPoint> availableVolumes = new ArrayList<EndPoint>(endPoint);
					Iterator<EndPoint> itav = availableVolumes.iterator();
					while (itav.hasNext()){
						EndPoint endPoint = itav.next();
						TableItem item = table.getItem(selectIndex);
						String[] data ={endPoint.getName(),
										endPoint.getProtocol(),
										endPoint.getPublicPort()==null?strAuto:endPoint.getPublicPort().toString(),
										endPoint.getPrivatePort().toString()};
						item.setText(data);
						table.setSelection(0);
					}
				}
			}
		});

		// 削除ボタン
		dummy = new Label(composite, SWT.NONE);
		this.buttonDelete = this.createButton(composite, Messages
				.getString("delete"));
		this.buttonDelete.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {

				//String notifyId = null;

				//Table table = notifyList.getTableViewer().getTable();
				item = table.getSelection();
				if(item != null && item.length>0){
					try{
						int selectIndex = table.getSelectionIndex();
						table.remove(selectIndex);
						endPoint.remove(selectIndex);
						//notifyId = (String)((ArrayList)item[0].getData()).get(GetNotifyTableDefineCheckBox.NOTIFY_ID);
					}
					catch(Exception ex){
					}
				}
				else{
					MessageDialog.openWarning(
							null,
							Messages.getString("warning"),
							msgMustDeleteEndPoint);
				}
			}
		});

		// ラインを引く
		Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalSpan = 8;
		line.setLayoutData(gridData);

		// 画面中央に
		Display display = shell.getDisplay();
		shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
				(display.getBounds().height - shell.getSize().y) / 2);

		//ダイアログのサイズ調整（pack:resize to be its preferred size）
		shell.pack();
		shell.setSize(new Point(sizeX, sizeY ));

	}

	@Override
	protected void okPressed() {

		endPoint.clear();
		for(int i=0; i < table.getItemCount(); i++){
			EndPoint ep = new EndPoint();
			ep.setName(table.getItem(i).getText(0));
			ep.setProtocol(table.getItem(i).getText(1));
			ep.setPublicPort(table.getItem(i).getText(2).equals(strAuto)?null:Integer.parseInt(table.getItem(i).getText(2)));
			ep.setPrivatePort(Integer.parseInt(table.getItem(i).getText(3)));
			endPoint.add(ep);
		}
		setReturnCode(OK);
		close();
	}


	@Override
	protected void cancelPressed() {

		endPoint.clear();
		close();

	}

	/**
	 * ボタンを返します。
	 *
	 * @param parent 親のコンポジット
	 * @param label ラベル文字列
	 * @return 生成されたボタン
	 */
	private Button createButton(Composite parent, String label) {
		Button button = new Button(parent, SWT.NONE);

		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		button.setLayoutData(gridData);

		button.setText(label);

		return button;
	}

	/**
	 * ボタンを生成します。<BR>
	 * 閉じるボタンを生成します。
	 *
	 * @param parent ボタンバーコンポジット
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	public CreateInstanceDialog.Model getOutput() {
		return output;
	}

	public void setEndPoint(List<EndPoint> endPoint) {
		this.endPoint = endPoint;
	}

	public List<EndPoint> getEndPoint() {
		return endPoint;
	}
	public void setTableItem(TableItem[] item) {
		this.item = item;
	}

	public void setOStype(String osType){
		this.osType = osType;
	}

	public String getOStype(){
		return this.osType;
	}
}