/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.azure.base.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProvider;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.AzureRestoreStorageRequest;

public class RestoreStorageDialog extends Dialog {
	public static class Decorator {
		private Combo control;

		private static ModifyListener modifyListener = new ModifyListener(){
			@Override
			public void modifyText(ModifyEvent e) {
				if(((Combo)e.getSource()).getText().equals("")){
					((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
				} else {
					((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				}
			}
		};

		public Decorator(Combo control) {
			this.control = control;
			setEnabled(false);
		}

		public void setEnabled(boolean enable) {
			if (enable) {
				if (control.getText().equals("")) {
					control.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
				}
				else {
					control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				}
				control.addModifyListener(modifyListener);
			}
			else {
				control.removeModifyListener(modifyListener);
				control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
			}
		}
	}

	public static class DialogData extends AzureRestoreStorageRequest {
		private String region;
		public String getRegion() {
			return region;
		}
		public void setRegion(String region) {
			this.region = region;
		}
	}

	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");

	private String strSeparator = messages.getString("caption.title_separator");
	private String strStorageSize = messages.getString("word.storage_size");
	private String strCreateStorageDialog = messages.getString("caption.restore_snapshot");
	private String strStorageAccountName = messages.getString("word.storage_account_name");
	private String strContainerName = messages.getString("word.container_name");
	private String strFileName = messages.getString("word.disc_name");

	private Text txtStorageAccount;
	private Text txtContainer;
	private Text txtFileName;

	private com.clustercontrol.ws.azure.SnapShotInfo snapShotInfo;

	private Text txtVolumeName;
	private Text txtSize;

	private CloudResourceProvider provider;

	private DialogData output = new DialogData();

	private IDialogBehavior behavior;

	public interface IDialogBehavior{
		void setProvider(CloudResourceProvider provider);

		void setupVolumeName(Text txtVolumeName);
		void setupSize(Text txtSize, Combo cmbUnit);
		void setupRegion(Combo cmbRegion);
		void setupAvailabilityZone(Combo cmbAvailabilityZone);
		void setupSnapshot(Combo cmbSnapshot);
		void setupVolumeType(Combo cmbVolumeType);
		void setupIops(Combo cmbIops);
	}

	public static class DialogBehavior implements IDialogBehavior{

		@Override
		public void setProvider(CloudResourceProvider provider) {}

		@Override
		public void setupVolumeName(Text txtVolumeName) {}

		@Override
		public void setupSize(Text txtSize, Combo txtUnit) {}

		@Override
		public void setupRegion(final Combo cmbRegion) {}

		@Override
		public void setupAvailabilityZone(Combo cmbAvailabilityZone) {}

		@Override
		public void setupSnapshot(Combo cmbSnapshot) {}

		@Override
		public void setupVolumeType(Combo cmbVolumeType) {}

		@Override
		public void setupIops(Combo cmbIops) {}

	}

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public RestoreStorageDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(4, false);
		gl_container.horizontalSpacing = 15;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);

		Label lblStorageAccountName = new Label(container, SWT.NONE);
		lblStorageAccountName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblStorageAccountName.setText(strStorageAccountName + strSeparator);

		txtStorageAccount = new Text(container, SWT.READ_ONLY | SWT.BORDER);
		txtStorageAccount.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		txtStorageAccount.setText(snapShotInfo.getStorageAccountName());

		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);

		Label lblContainerName = new Label(container, SWT.NONE);
		lblContainerName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblContainerName.setText(strContainerName + strSeparator);

		txtContainer = new Text(container, SWT.READ_ONLY | SWT.BORDER);
		txtContainer.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		txtContainer.setText(snapShotInfo.getContainerName());
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);

		Label lblFileName = new Label(container, SWT.NONE);
		lblFileName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblFileName.setText(strFileName + strSeparator);

		txtFileName = new Text(container, SWT.BORDER);
		txtFileName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		txtFileName.setText(snapShotInfo.getVHDFileName());
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);

		Label lblSize = new Label(container, SWT.NONE);
		lblSize.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblSize.setText(strStorageSize + strSeparator);

		txtSize = new Text(container, SWT.READ_ONLY | SWT.BORDER);
		txtSize.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		txtSize.setText(Integer.toString(snapShotInfo.getFileSize()));

		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);

		behavior.setProvider(provider);
		behavior.setupVolumeName(txtVolumeName);

		txtSize.addVerifyListener(new VerifyListener() {
			public void verifyText(VerifyEvent e) {
				try {
					String t = txtSize.getText().substring(0, e.start) + e.text + txtSize.getText().substring(e.start);
					if (t.length() != 0) {
						Integer.valueOf(t);
					}
				}
				catch(Exception e1) {
					e.doit = false;
				}
			}
		});

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 320);
	}

	@Override
	protected void okPressed() {
		if("".equals(txtStorageAccount.getText()) ||
				"".equals(txtContainer.getText()) ||
				"".equals(txtFileName.getText()) ||
				"".equals(txtSize.getText())
			){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					messages.getString("message.must_fully_input"));
			return;
		}

		output = new DialogData();
		output.setDiskName(txtFileName.getText());

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strCreateStorageDialog);
	}

	public RestoreStorageDialog.DialogData getOutput() {
		return output;
	}

	public void setCloudInfoProvider(CloudResourceProvider provider) {
		this.provider = provider;
	}

	public void setBehavior(IDialogBehavior behavior) {
		this.behavior = behavior;
	}

	public com.clustercontrol.ws.azure.SnapShotInfo getSnapShotInfo() {
		return snapShotInfo;
	}
	public void setSnapShotInfo(com.clustercontrol.ws.azure.SnapShotInfo snapShotInfo) {
		this.snapShotInfo = snapShotInfo;
	}
}
