/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.azure.base.ui.views.actions;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Combo;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.azure.base.ui.dialogs.CreateTemplateDialog;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.presenter.IAccountResource.IRegion;
import com.clustercontrol.cloud.ui.views.TemplatesView;
import com.clustercontrol.cloud.ui.views.actions.AbstractViewAction;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.util.Messages;


public class CreateTemplateAction extends AbstractViewAction {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String msgCreateTemplateConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.template", "word.create"});
	private String msgCreateTemplateResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.template", "word.create"});

	private CloudResourceProvider provider;
	private IRegion region;
	
	@Override
	protected void invoke(IAction action) throws InvocationException {
		final IAccountResource accountResource = ((TemplatesView)viewPart).getAccountResource();
		provider = new CloudResourceProviderImpl(accountResource.getAccountResourceId());
		
		if(((TemplatesView)viewPart).getActiveRegion() != null){
			region = ((TemplatesView)viewPart).getActiveRegion();
		}
		
		CreateTemplateDialog dialog = new CreateTemplateDialog(this.viewPart.getSite().getShell());
		dialog.setCloudInfoProvider(provider);
		try {
			dialog.setBehavior(new CreateTemplateDialog.DialogBehavior(){
				private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
				private List<TemplateJobUtil.TemplateJobnet> templateJobs;
				{
					try{
						templateJobs = TemplateJobUtil.getTemplateJobList(accountResource.getAccountResourceId(), true);
					} catch(com.clustercontrol.ws.jobmanagement.InvalidRole_Exception e) {
						MessageDialog.openError(null, Messages.getString("failed"), e.getMessage());
						templateJobs = new ArrayList<TemplateJobUtil.TemplateJobnet>();
					}
				}
				private IRegion region = CreateTemplateAction.this.region;

				@Override
				public void setupRegion(Combo region) {
					for (String regionName: provider.getAllRegion()) {
						String regionLocaleName = messages.getString(regionName);
						region.add(regionLocaleName);
						region.setData(regionLocaleName, regionName);
					}
					if (this.region != null) {
						String regionLocaleName = messages.getString(this.region.getRegionName());
						region.select(region.indexOf(regionLocaleName));
					} else {
						region.select(0);
					}
				}

				@Override
				public void setupLaunchJobId(Combo launchJobId){
					for(TemplateJobUtil.TemplateJobnet childJobItem : templateJobs){
						String jobId = childJobItem.getJobnetId();
						String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
						launchJobId.add(jobName);
						launchJobId.setData(jobName, jobId);
					}
				}

				@Override
				public void setupStartJobId(Combo startJobId) {
					for(TemplateJobUtil.TemplateJobnet childJobItem : templateJobs){
						String jobId = childJobItem.getJobnetId();
						String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
						startJobId.add(jobName);
						startJobId.setData(jobName, jobId);
					}
				}

				@Override
				public void setupStopJobId(Combo stopJobId) {
					for(TemplateJobUtil.TemplateJobnet childJobItem : templateJobs){
						String jobId = childJobItem.getJobnetId();
						String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
						stopJobId.add(jobName);
						stopJobId.setData(jobName, jobId);
					}
				}
			});
		} catch (Exception e) {
			throw new InvocationException(e);
		}

		if (dialog.open() == Window.OK) {
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgCreateTemplateConfirm)) {

				ICloudTemplateManager templateManager = accountResource.getCloudTemplateManager();
				
				templateManager.createCloudTemplate(dialog.getOutput());
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgCreateTemplateResult);
			}
			else {
				return;
			}
		}
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		if(((TemplatesView)viewPart).getAccountResource() != null){
			action.setEnabled(true);
		} else {
			action.setEnabled(false);
		}
	}
}