/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.calendar.ui;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;

import com.clustercontrol.ClusterControlPerspectiveBase;
import com.clustercontrol.calendar.view.CalendarPatternView;
import com.clustercontrol.calendar.view.CalendarListView;
import com.clustercontrol.calendar.view.CalendarMonthView;
import com.clustercontrol.calendar.view.CalendarWeekView;

/**
 * カレンダパースペクティブクラス<BR>
 * 
 * @version 4.1.0
 * @since 2.0.0
 */
public class CalendarPerspective extends ClusterControlPerspectiveBase {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IPerspectiveFactory#createInitialLayout(org.eclipse.ui.IPageLayout)
	 */
	@Override
	public void createInitialLayout(IPageLayout layout) {
		super.createInitialLayout(layout);

		//エディタ領域のIDを取得
		String editorArea = layout.getEditorArea();
		//エディタ領域の上部45%を占めるフォルダを作成
		float upper = 0.45f;
		IFolderLayout top = layout.createFolder("top", IPageLayout.TOP, upper, editorArea);
		//エディタ領域の上部左55%を占めるフォルダを作成
		IFolderLayout topLeft = layout.createFolder("topLeft",IPageLayout.LEFT, 0.55f, "top");
		//エディタ領域の下部55%を占めるフォルダの作成
		IFolderLayout bottom = layout.createFolder("bottom",IPageLayout.BOTTOM, 1 - upper, editorArea);

		topLeft.addView(CalendarListView.ID);
		topLeft.addView(CalendarPatternView.ID);
		top.addView(CalendarMonthView.ID);
		bottom.addView(CalendarWeekView.ID);
	}
}