/*

Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.calendar.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.calendar.util.CalendarEndpointWrapper;
import com.clustercontrol.calendar.view.CalendarPatternView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.calendar.InvalidRole_Exception;

/**
 * カレンダ[カレンダパターン]の削除を行うクライアント側アクションクラス<BR>
 * 
 * @version 4.1.0
 * @since 4.1.0
 */
public class CalendarPatternDeleteAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.calendar.view.action.CalendarPatternDeleteAction";

	private IViewPart viewPart;

	/**
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	@Override
	public void run(IAction action) {
		// カレンダ[カレンダパターン]より、選択されているカレンダパターンIDを取得

		CalendarPatternView view = (CalendarPatternView) this.viewPart
				.getAdapter(CalendarPatternView.class);

		String id = view.getSelectedId();

		if (id != null) {
			// 確認ダイアログにて変更が選択された場合、削除処理を行う。
			String[] args = { id };
			if (MessageDialog.openConfirm(
					null,
					Messages.getString("confirmed"),
					Messages.getString("message.calendar.49", args))) {
				try {
					CalendarEndpointWrapper.deleteCalendarPattern(id);

					// 成功報告ダイアログを生成
					MessageDialog.openInformation(
							null,
							Messages.getString("successful"),
							Messages.getString("message.calendar.38"));

				} catch (Exception e) {
					String errMessage = "";
					if (e instanceof InvalidRole_Exception) {
						// 権限なし
						MessageDialog.openInformation(null, Messages.getString("message"),
								Messages.getString("message.accesscontrol.16"));
					} else {
						errMessage = ", " + e.getMessage();
					}

					// 失敗報告ダイアログを生成
					MessageDialog.openError(
							null,
							Messages.getString("failed"),
							Messages.getString("message.calendar.39") + errMessage);
				}
				// ビューを更新
				view.update();
			}
		}
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}
}