/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.action;

import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.util.Messages;

/**
 * 一括制御[履歴]テーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetHistoryTableDefine {

	/** 状態 */
	public static int STATUS = 0;

	/** セッションID */
	public static int SESSION_ID = 1;

	/** 開始日時 */
	public static int START_TIME = 2;

	/** 終了日時 */
	public static int END_TIME = 3;

	/** 種別 */
	public static int TYPE = 4;

	/** 名前 */
	public static int NAME = 5;

	/** ファシリティID */
	public static int FACILITY_ID = 6;

	/** スコープ */
	public static int SCOPE = 7;

	/** 合計 */
	public static int TOTAL = 8;

	/** 正常 */
	public static int NORMAL = 9;

	/** 警告 */
	public static int WARNING = 10;

	/** 異常 */
	public static int ABNORMAL = 11;

	/** 待機中 */
	public static int WAITING = 12;

	/** 実行中 */
	public static int RUNNING = 13;

	/** 初期表示時ソートカラム */
	public static int SORT_COLUMN_INDEX = SESSION_ID;

	/** 初期表示時ソートオーダー */
	public static int SORT_ORDER = -1;


	/**
	 * 履歴テーブル定義を取得します。<BR>
	 * 
	 * @return 履歴テーブル定義
	 */
	public static ArrayList<TableColumnInfo> get() {
		//テーブル定義配列
		ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
		Locale locale = Locale.getDefault();

		tableDefine.add(STATUS,
				new TableColumnInfo(Messages.getString("run.status", locale), TableColumnInfo.CRUN_STATUS, 60, SWT.LEFT));
		tableDefine.add(SESSION_ID,
				new TableColumnInfo(Messages.getString("session.id", locale), TableColumnInfo.NONE, 140, SWT.LEFT));
		tableDefine.add(START_TIME,
				new TableColumnInfo(Messages.getString("start.time", locale), TableColumnInfo.NONE, 140, SWT.LEFT));
		tableDefine.add(END_TIME,
				new TableColumnInfo(Messages.getString("end.time", locale), TableColumnInfo.NONE, 140, SWT.LEFT));
		tableDefine.add(TYPE,
				new TableColumnInfo(Messages.getString("type", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(NAME,
				new TableColumnInfo(Messages.getString("name", locale), TableColumnInfo.NONE, 140, SWT.LEFT));
		tableDefine.add(FACILITY_ID,
				new TableColumnInfo(Messages.getString("facility.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(SCOPE,
				new TableColumnInfo(Messages.getString("scope", locale), TableColumnInfo.FACILITY, 150, SWT.LEFT));
		tableDefine.add(TOTAL,
				new TableColumnInfo(Messages.getString("total", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
		tableDefine.add(NORMAL,
				new TableColumnInfo(Messages.getString("successful", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
		tableDefine.add(WARNING,
				new TableColumnInfo(Messages.getString("warning", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
		tableDefine.add(ABNORMAL,
				new TableColumnInfo(Messages.getString("failed", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
		tableDefine.add(WAITING,
				new TableColumnInfo(Messages.getString("waiting", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
		tableDefine.add(RUNNING,
				new TableColumnInfo(Messages.getString("running", locale), TableColumnInfo.NONE, 50, SWT.LEFT));

		return tableDefine;
	}
}