package com.clustercontrol.monitor.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import com.clustercontrol.monitor.action.GetEventListTableDefine;
import com.clustercontrol.monitor.action.GetScopeListTableDefine;
import com.clustercontrol.monitor.action.GetStatusListTableDefine;
import com.clustercontrol.ws.monitor.EventDataInfo;
import com.clustercontrol.ws.monitor.ScopeDataInfo;
import com.clustercontrol.ws.monitor.StatusDataInfo;

public class ConvertListUtil {


	/**
	 * 
	 * SessionBean経由で取得されたEventLogDataのリストを、
	 * 表示用のリスト（ArrayListの二次元配列）に変換するためのメソッドです。
	 * 
	 * @param list
	 * @return
	 */
	public static ArrayList eventLogDataListToArrayList(List<EventDataInfo> list){

		ArrayList ret = new ArrayList();
		Iterator<EventDataInfo> itr = list.iterator();

		for(EventDataInfo eventLogData : list) {
			ArrayList event = new ArrayList();

			event.add(GetEventListTableDefine.PRIORITY, eventLogData.getPriority());
			event.add(GetEventListTableDefine.RECEIVE_TIME, new Date(eventLogData.getOutputDate()));
			event.add(GetEventListTableDefine.OUTPUT_DATE, new Date(eventLogData.getGenerationDate()));
			event.add(GetEventListTableDefine.PLUGIN_ID, eventLogData.getPluginId());
			event.add(GetEventListTableDefine.MONITOR_ID, eventLogData.getMonitorId());
			event.add(GetEventListTableDefine.MONITOR_DETAIL_ID, eventLogData.getMonitorDetailId());
			event.add(GetEventListTableDefine.FACILITY_ID, eventLogData.getFacilityId());
			event.add(GetEventListTableDefine.SCOPE, eventLogData.getScopeText());
			event.add(GetEventListTableDefine.APPLICATION, eventLogData.getApplication());
			event.add(GetEventListTableDefine.MESSAGE_ID, eventLogData.getMessageId());
			event.add(GetEventListTableDefine.MESSAGE, eventLogData.getMessage());
			event.add(GetEventListTableDefine.CONFIRMED, eventLogData.getConfirmed());
			event.add(GetEventListTableDefine.CONFIRM_USER, eventLogData.getConfirmUser());
			event.add(GetEventListTableDefine.COMMENT, eventLogData.getComment());
			event.add(GetEventListTableDefine.OWNER_ROLE, eventLogData.getOwnerRoleId());

			ret.add(event);
		}

		return ret;
	}


	/**
	 * 
	 * 監視[イベント]ビューに表示される内容を基にして、
	 * EventLogDataのリストに変換するためのメソッドです。
	 * 
	 * オリジナルメッセージのように、表示されていない項目については、
	 * セットされないので注意してください。
	 * 
	 * @param list
	 * @return
	 */
	public static ArrayList<EventDataInfo> listToEventLogDataList(List list) {

		ArrayList<EventDataInfo> eventLogDataList = new ArrayList<EventDataInfo>();
		Iterator itr = list.iterator();
		while(itr.hasNext()) {

			ArrayList event = (ArrayList) itr.next();

			Integer priority = (Integer) event.get(GetEventListTableDefine.PRIORITY);
			Timestamp outputDate = new Timestamp (((Date) event.get(GetEventListTableDefine.RECEIVE_TIME)).getTime());
			Timestamp generationDate = new Timestamp (((Date) event.get(GetEventListTableDefine.OUTPUT_DATE)).getTime());
			String pluginId = (String) event.get(GetEventListTableDefine.PLUGIN_ID);
			String monitorId = (String) event.get(GetEventListTableDefine.MONITOR_ID);
			String monitorDetailId = (String) event.get(GetEventListTableDefine.MONITOR_DETAIL_ID);
			String facilityId = (String) event.get(GetEventListTableDefine.FACILITY_ID);
			String scopeText = (String) event.get(GetEventListTableDefine.SCOPE);
			String application = (String) event.get(GetEventListTableDefine.APPLICATION);
			String messageId = (String) event.get(GetEventListTableDefine.MESSAGE_ID);
			String message = (String) event.get(GetEventListTableDefine.MESSAGE);
			Integer confirmFlg = (Integer) event.get(GetEventListTableDefine.CONFIRMED);
			String confirmUser = (String) event.get(GetEventListTableDefine.CONFIRM_USER);
			String comment = (String) event.get(GetEventListTableDefine.COMMENT);
			String ownerRoleId = (String) event.get(GetEventListTableDefine.OWNER_ROLE);
			Timestamp commentDate = null;

			EventDataInfo eventLogData = new EventDataInfo();
			eventLogData.setPriority(priority);
			eventLogData.setOutputDate(outputDate.getTime());
			eventLogData.setGenerationDate(generationDate.getTime());
			eventLogData.setPluginId(pluginId);
			eventLogData.setMonitorId(monitorId);
			eventLogData.setMonitorDetailId(monitorDetailId);
			eventLogData.setFacilityId(facilityId);
			eventLogData.setScopeText(scopeText);
			eventLogData.setApplication(application);
			eventLogData.setMessageId(messageId);
			eventLogData.setMessage(message);
			eventLogData.setConfirmed(confirmFlg);
			eventLogData.setConfirmUser(confirmUser);
			eventLogData.setComment(comment);
			eventLogData.setOwnerRoleId(ownerRoleId);

			eventLogDataList.add(eventLogData);


		}

		return eventLogDataList;

	}

	public static ArrayList statusInfoDataListToArrayList(List<StatusDataInfo> list) {

		ArrayList ret  = new ArrayList();
		Iterator<StatusDataInfo> itr = list.iterator();

		while(itr.hasNext()) {
			ArrayList status = new ArrayList();
			StatusDataInfo statusInfoData = itr.next();
			status.add(GetStatusListTableDefine.PRIORITY, statusInfoData.getPriority());
			status.add(GetStatusListTableDefine.PLUGIN_ID, statusInfoData.getPluginId());
			status.add(GetStatusListTableDefine.MONITOR_ID, statusInfoData.getMonitorId());
			status.add(GetStatusListTableDefine.MONITOR_DETAIL_ID, statusInfoData.getMonitorDetailId());
			status.add(GetStatusListTableDefine.FACILITY_ID, statusInfoData.getFacilityId());
			status.add(GetStatusListTableDefine.SCOPE, statusInfoData.getFacilityPath());
			status.add(GetStatusListTableDefine.APPLICATION, statusInfoData.getApplication());
			status.add(GetStatusListTableDefine.UPDATE_TIME, new Date(statusInfoData.getOutputDate()));
			status.add(GetStatusListTableDefine.OUTPUT_TIME, new Date(statusInfoData.getGenerationDate()));
			status.add(GetStatusListTableDefine.MESSAGE_ID, statusInfoData.getMessageId());
			status.add(GetStatusListTableDefine.MESSAGE, statusInfoData.getMessage());
			status.add(GetStatusListTableDefine.OWNER_ROLE, statusInfoData.getOwnerRoleId());

			ret.add(status);
		}

		return ret;

	}

	public static ArrayList<StatusDataInfo> listToStatusInfoDataList(List list) {


		ArrayList<StatusDataInfo> ret = new ArrayList<StatusDataInfo>();
		Iterator itr = list.iterator();

		while (itr.hasNext()) {

			ArrayList status = (ArrayList) itr.next();

			String monitorId = (String) status.get(GetStatusListTableDefine.MONITOR_ID);
			String monitorDetailId = (String) status.get(GetStatusListTableDefine.MONITOR_DETAIL_ID);
			String pluginId = (String) status.get(GetStatusListTableDefine.PLUGIN_ID);
			String facilityId = (String) status.get(GetStatusListTableDefine.FACILITY_ID);
			String application = (String) status.get(GetStatusListTableDefine.APPLICATION);
			Long generationDate = ((Date) status.get(GetStatusListTableDefine.OUTPUT_TIME)).getTime();
			String messageId = (String) status.get(GetStatusListTableDefine.MESSAGE_ID);
			String message = (String) status.get(GetStatusListTableDefine.MESSAGE);
			Integer priority = (Integer) status.get(GetStatusListTableDefine.PRIORITY);
			String ownerRoleId = (String) status.get(GetStatusListTableDefine.OWNER_ROLE);

			StatusDataInfo info = new StatusDataInfo();
			info.setMonitorId(monitorId);
			info.setMonitorDetailId(monitorDetailId);
			info.setPluginId(pluginId);
			info.setFacilityId(facilityId);
			info.setApplication(application);
			info.setGenerationDate(generationDate);
			info.setMessageId(messageId);
			info.setMessage(message);
			info.setPriority(priority);
			info.setOwnerRoleId(ownerRoleId);

			ret.add(info);
		}

		return ret;
	}



	public static ArrayList scopeInfoDataListToArrayList(List<ScopeDataInfo> list) {

		ArrayList ret  = new ArrayList();

		Iterator<ScopeDataInfo> itr = list.iterator();
		while(itr.hasNext()) {
			ArrayList status = new ArrayList();
			ScopeDataInfo scopeInfoData = itr.next();
			status.add(GetScopeListTableDefine.PRIORITY, scopeInfoData.getPriority());
			status.add(GetScopeListTableDefine.FACILITY_ID, scopeInfoData.getFacilityId());
			status.add(GetScopeListTableDefine.SCOPE, scopeInfoData.getFacilityPath());
			status.add(GetScopeListTableDefine.UPDATE_TIME, new Date(scopeInfoData.getOutputDate()));
			status.add(GetScopeListTableDefine.SORT_VALUE, scopeInfoData.getSortValue());

			ret.add(status);
		}

		return ret;

	}

}
