/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.monitor.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.dialog.MonitorFilterDialog;
import com.clustercontrol.monitor.view.MonitorListView;

/**
 * 監視[一覧]ビューのフィルタ表示アクションクラス<BR>
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class MonitorFilterAction implements IViewActionDelegate {

	/** アクションID */
	public static final String ID = "com.clustercontrol.monitor.view.action.MonitorFilterAction";

	/** ビュー */
	private IViewPart viewPart;

	/**
	 * フィルタアクションのメイン処理
	 */
	@Override
	public void run(IAction action) {
		MonitorListView view = (MonitorListView) this.viewPart.getAdapter(MonitorListView.class);

		if (action.isChecked()) {
			// ダイアログを生成
			MonitorFilterDialog dialog = new MonitorFilterDialog(this.viewPart
					.getSite().getShell());

			// ダイアログにて検索が選択された場合、検索結果をビューに表示
			if (dialog.open() == IDialogConstants.OK_ID) {

				Property condition = dialog.getInputData();

				view.update(condition);
			} else {
				action.setChecked(false);
			}
		} else {
			// 検索条件クリア
			view.update(null);
		}
	}

	/**
	 * 選択変更時のアクション
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * viewPartの初期化
	 */
	@Override
	public void init(IViewPart view) {
		this.viewPart = view;
	}

}
