/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.repository.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.repository.composite.AgentListComposite;
import com.clustercontrol.repository.view.action.AgentRestartAction;
import com.clustercontrol.repository.view.action.AgentUpdateAction;
import com.clustercontrol.view.CommonViewPart;

/**
 * ノート一覧ビュークラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class AgentListView extends CommonViewPart {
	public static final String ID = "com.clustercontrol.repository.view.AgentListView";

	// ----- instance フィールド ----- //

	/** ノード一覧コンポジット */
	private AgentListComposite composite = null;

	// ----- コンストラクタ ----- //

	/**
	 * インスタンスを返します。
	 */
	public AgentListView() {
		super();
	}

	// ----- instance メソッド ----- //

	/**
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createPartControl(Composite parent) {
		GridLayout layout = new GridLayout(1, true);
		parent.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;

		composite = new AgentListComposite(parent, SWT.NONE);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		composite.setLayoutData(gridData);

		//ポップアップメニュー作成
		createContextMenu();

		// ボタン（アクション）を制御するリスナーを登録
		composite.getTableViewer().addSelectionChangedListener(
				new ISelectionChangedListener() {

					@Override
					public void selectionChanged(SelectionChangedEvent event) {
						//リポジトリ[エージェント]ビューのインスタンスを取得
						IWorkbenchPage page = PlatformUI.getWorkbench()
								.getActiveWorkbenchWindow().getActivePage();
						IViewPart viewPart = page.findView(AgentListView.ID);
						//選択アイテムを取得
						StructuredSelection selection = (StructuredSelection) event.getSelection();

						if ( viewPart != null && selection != null) {
							AgentListView view = (AgentListView) viewPart.getAdapter(AgentListView.class);
							//ビューのボタン（アクション）の使用可/不可を設定する
							view.setEnabledAction(selection.size(), event.getSelection());
						}
					}
				});
		update();
	}

	/**
	 * ポップアップメニュー作成
	 * 
	 * 
	 */
	private void createContextMenu() {
		MenuManager menuManager = new MenuManager();
		menuManager.setRemoveAllWhenShown(true);
		menuManager.addMenuListener(new IMenuListener() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
			 */
			@Override
			public void menuAboutToShow(IMenuManager manager) {
				//メニュー項目設定
				fillContextMenu(manager);
			}
		});

		Menu menu = menuManager.createContextMenu(composite.getTable());
		composite.getTable().setMenu(menu);
	}

	/**
	 * メニュー項目追加
	 * 
	 * @param manager
	 */
	private void fillContextMenu(IMenuManager manager) {
		//ビューのアクションのインスタンスを取得
		IToolBarManager toolbar = this.getViewSite().getActionBars()
				.getToolBarManager();
		ActionContributionItem agentRestartAction = (ActionContributionItem) toolbar
				.find(AgentRestartAction.ID);
		ActionContributionItem agentUpdateAction = (ActionContributionItem) toolbar
				.find(AgentUpdateAction.ID);

		//ポップアップメニューにアクションを追加
		manager.add(agentRestartAction.getAction());
		manager.add(agentUpdateAction.getAction());
	}

	/**
	 * compositeを返します。
	 * 
	 * @return composite
	 */
	public AgentListComposite getComposite() {
		return composite;
	}

	/**
	 * エージェントの一覧を表示します。
	 * <p>
	 */
	public void update() {

		composite.update();
	}

	/**
	 * ビューのアクションの有効/無効を設定します。
	 * 
	 * @param num 選択イベント数
	 * @param selection ボタン（アクション）を有効にするための情報
	 */
	public void setEnabledAction(int num, ISelection selection) {
		super.setEnabledAction(AgentRestartAction.ID, selection);
		super.setEnabledAction(AgentUpdateAction.ID, selection);

		if(num > 0){
			super.setEnabledAction(AgentRestartAction.ID, true);
			super.setEnabledAction(AgentUpdateAction.ID, true);
		}else{
			super.setEnabledAction(AgentRestartAction.ID, false);
			super.setEnabledAction(AgentUpdateAction.ID, false);
		}
	}
}