/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.repository.view.action;

import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.repository.action.GetNodeListTableDefine;
import com.clustercontrol.repository.dialog.NodeCreateDialog;
import com.clustercontrol.repository.view.NodeListView;
import com.clustercontrol.viewer.CommonTableViewer;

/**
 * ノードの作成・変更ダイアログによる、ノード変更を行うクライアント側アクションクラス<BR>
 * 
 * @version 2.2.0
 * @since 1.0.0
 */
public class NodeCopyAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.repository.view.action.NodeCopyAction";

	//	 ----- instance フィールド ----- //

	private IViewPart viewPart; // ビュー

	// ----- instance メソッド ----- //

	/**
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	@Override
	public void run(IAction action) {
		// ノード一覧より、選択されているノードのファシリティIDを取得

		NodeListView view = (NodeListView) this.viewPart
				.getAdapter(NodeListView.class);

		StructuredSelection selection = (StructuredSelection) view
				.getComposite().getTableViewer().getSelection();

		List list = (List) selection.getFirstElement();
		String facilityId = null;
		if (list != null) {
			facilityId = (String) list.get(GetNodeListTableDefine.FACILITY_ID);
		}

		if (facilityId != null) {
			// ダイアログを生成
			NodeCreateDialog dialog = new NodeCreateDialog(this.viewPart
					.getSite().getShell(), facilityId, false);

			// ダイアログにて変更が選択された場合、入力内容をもって更新を行う。
			if (dialog.open() == IDialogConstants.OK_ID) {
				view.update();

				// 選択させることで、他のビューの更新を促す。
				CommonTableViewer viewer = view.getComposite().getTableViewer();
				viewer.setSelection(viewer.getSelection());
			}
		}
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}
}