/*

Copyright (C) 2012 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.commons.bean;

/**
 * Manager外のコンポーネントが利用する設定情報の最終更新日時を保存するクラス
 * @since 4.0
 */
public class SettingUpdateInfo {

	private static SettingUpdateInfo instance = new SettingUpdateInfo();

	private volatile long calendarUpdateTime = System.currentTimeMillis();
	private volatile long repositoryUpdateTime = System.currentTimeMillis();

	private volatile long customMonitorUpdateTime = System.currentTimeMillis();
	private volatile long logFileMonitorUpdateTime = System.currentTimeMillis();
	private volatile long systemLogMonitorUpdateTime = System.currentTimeMillis();
	private volatile long snmptrapMonitorUpdateTime = System.currentTimeMillis();
	private volatile long winEventMonitorUpdateTime = System.currentTimeMillis();
	private volatile long jobFileCheckUpdateTime = System.currentTimeMillis();

	private SettingUpdateInfo() {

	}

	public static SettingUpdateInfo getInstance() {
		return instance;
	}

	public void setRepositoryUpdateTime(long time) {
		repositoryUpdateTime = time;
	}

	public long getRepositoryUpdateTime() {
		return repositoryUpdateTime;
	}

	public void setCalendarUpdateTime(long time) {
		calendarUpdateTime = time;
	}

	public long getCalendarUpdateTime() {
		return calendarUpdateTime;
	}

	public void setCustomMonitorUpdateTime(long time) {
		customMonitorUpdateTime = time;
	}

	public long getCustomMonitorUpdateTime() {
		return customMonitorUpdateTime;
	}

	public void setLogFileMonitorUpdateTime(long time) {
		logFileMonitorUpdateTime = time;
	}

	public long getLogFileMonitorUpdateTime() {
		return logFileMonitorUpdateTime;
	}

	public void setSystemLogMonitorUpdateTime(long time) {
		systemLogMonitorUpdateTime = time;
	}

	public long getSystemLogMonitorUpdateTime() {
		return systemLogMonitorUpdateTime;
	}

	public void setSnmptrapMonitorUpdateTime(long time) {
		snmptrapMonitorUpdateTime = time;
	}

	public long getSnmptrapMonitorUpdateTime() {
		return snmptrapMonitorUpdateTime;
	}

	public long getWinEventMonitorUpdateTime() {
		return winEventMonitorUpdateTime;
	}

	public void setWinEventMonitorUpdateTime(long winEventMonitorUpdateTime) {
		this.winEventMonitorUpdateTime = winEventMonitorUpdateTime;
	}

	public long getJobFileCheckUpdateTime() {
		return jobFileCheckUpdateTime;
	}

	public void setJobFileCheckUpdateTime(long jobFileCheckUpdateTime) {
		this.jobFileCheckUpdateTime = jobFileCheckUpdateTime;
	}
}
