/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;

import javax.xml.bind.annotation.XmlType;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.notify.bean.NotifyRelationInfo;

/**
 * ジョブの通知に関する情報を保持するクラス<BR>
 * 
 * @version 3.0.0
 * @since 1.0.0
 */
@XmlType(namespace = "http://jobmanagement.ws.clustercontrol.com")
public class JobNotificationsInfo implements Serializable, Comparable<JobNotificationsInfo> {
	/** シリアライズ可能クラスに定義するUID */
	private static final long serialVersionUID = 3052367114166008592L;

	/** ログ出力のインスタンス<BR> */
	private static Log m_log = LogFactory.getLog( JobNotificationsInfo.class );

	/** 終了状態 */
	private Integer m_type = new Integer(0);

	/** 重要度 */
	private Integer m_priority = new Integer(0);

	/** 通知グループID */
	private String m_notifyGroupId;


	/** 通知ID**/
	private ArrayList<NotifyRelationInfo> m_notifyId;



	/**
	 * コンストラクター
	 */
	public JobNotificationsInfo() {
		super();

	}

	/**
	 * 重要度を返す。<BR>
	 * @return 重要度
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public Integer getPriority() {
		return m_priority;
	}

	/**
	 * 重要度を設定する。<BR>
	 * @param priority 重要度
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public void setPriority(Integer priority) {
		this.m_priority = priority;
	}

	/**
	 * 通知IDを返す。<BR>
	 * @return 通知ID
	 */
	public String getNotifyGroupId() {
		return m_notifyGroupId;
	}

	/**
	 * 通知IDを設定する。<BR>
	 * @param notify_id 通知ID
	 */
	public void setNotifyGroupId(String notifyGroupId) {
		this.m_notifyGroupId = notifyGroupId;
	}

	/**
	 * 終了状態を返す。<BR>
	 * @return 終了状態
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public Integer getType() {
		return m_type;
	}

	/**
	 * 終了状態を設定する。<BR>
	 * @param type 終了状態
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public void setType(Integer type) {
		this.m_type = type;
	}

	/**
	 * 通知IDを返します。
	 * @return　通知IDのコレクション
	 */
	public ArrayList<NotifyRelationInfo> getNotifyId() {
		return m_notifyId;
	}

	/**
	 * 通知IDを設定します。
	 * 
	 * @param notifyId
	 */
	public void setNotifyId(ArrayList<NotifyRelationInfo> notifyId) {
		this.m_notifyId = notifyId;
	}

	@Override
	public boolean equals(Object o) {
		if (!(o instanceof JobNotificationsInfo)) {
			return false;
		}
		JobNotificationsInfo o1 = this;
		JobNotificationsInfo o2 = (JobNotificationsInfo)o;

		boolean ret = false;
		ret = 	equalsSub(o1.getNotifyGroupId(), o2.getNotifyGroupId()) &&
				equalsSub(o1.getType(), o2.getType()) &&
				equalsSub(o1.getPriority(), o2.getPriority()) &&
				equalsArray(o1.getNotifyId(), o2.getNotifyId());

		if (!ret) {
			m_log.debug("type : o1 = " + o1.getType() + ", o2 = " + o2.getType());
			m_log.debug("priority : o1 = " + o1.getPriority() + ", o2 = " + o2.getPriority());
			m_log.debug("notifyGroupId : o1 = " + o1.getNotifyGroupId() + ", o2 = " + o2.getNotifyGroupId());
			m_log.debug("notifyId : o1 = " + o1.getNotifyId() + ", o2 = " + o2.getNotifyId());
		}

		return ret;
	}

	private boolean equalsSub(Object o1, Object o2) {
		if (o1 == null && o2 == null) {
			return true;
		}
		if (o1 != null && o2 == null) {
			return false;
		}
		if (o1 == null && o2 != null) {
			return false;
		}
		boolean ret = o1.equals(o2);
		if (!ret) {
			if (m_log.isTraceEnabled()) {
				m_log.trace("equalsSub : " + o1 + "!=" + o2);
			}
		}
		return ret;
	}

	private boolean equalsArray(ArrayList<NotifyRelationInfo> list1, ArrayList<NotifyRelationInfo> list2) {
		if ((list1 == null || list1.size() == 0) && (list2 == null || list2.size() == 0)) {
			return true;
		}
		if (list1 != null && list2 == null) {
			if (list1.isEmpty()) {
				return true;
			}
			return false;
		}
		if (list1 == null && list2 != null) {
			if (list2.isEmpty()) {
				return true;
			}
			return false;
		}
		if (list1.size() != list2.size()) {
			return false;
		}
		Collections.sort(list1);
		Collections.sort(list2);
		for (int i = 0; i < list1.size(); i++) {
			if (!list1.get(i).equals(list2.get(i))) {
				return false;
			}
		}
		return true;
	}

	@Override
	public int compareTo(JobNotificationsInfo o) {
		//return this.getType() - o.getType();
		return (this.m_type + this.m_notifyGroupId + this.m_priority).compareTo(
				o.m_type + o.m_notifyGroupId + o.m_priority);
	}

	/**
	 * 単体テスト用
	 * @param args
	 */
	public static void main (String args[]) {
		testEquals();
	}

	public static void testEquals() {

		System.out.println("=== JobNotificationsInfo の単体テスト ===");

		System.out.println("*** 全部一致 ***");
		JobNotificationsInfo info1 = new JobNotificationsInfo();
		info1.setType(0);
		info1.setPriority(0);
		info1.setNotifyGroupId("notifyGroup");
		ArrayList<NotifyRelationInfo> notifyList1 = new ArrayList<NotifyRelationInfo>();
		{
			NotifyRelationInfo notify1 = new NotifyRelationInfo();
			notify1.setNotifyGroupId("notifyGroup");
			notify1.setNotifyId("notify1");
			notify1.setNotifyType(0);
			notify1.setNotifyFlg(0);

			NotifyRelationInfo notify2 = new NotifyRelationInfo();
			notify2.setNotifyGroupId("notifyGroup");
			notify2.setNotifyId("notify2");
			notify2.setNotifyType(1);
			notify2.setNotifyFlg(1);

			notifyList1.add(notify1);
			notifyList1.add(notify2);
		}
		info1.setNotifyId(notifyList1);

		JobNotificationsInfo info2 = new JobNotificationsInfo();
		info2.setType(0);
		info2.setPriority(0);
		info2.setNotifyGroupId("notifyGroup");
		ArrayList<NotifyRelationInfo> notifyList2 = new ArrayList<NotifyRelationInfo>();
		{
			NotifyRelationInfo notifyA = new NotifyRelationInfo();
			notifyA.setNotifyGroupId("notifyGroup");
			notifyA.setNotifyId("notify1");
			notifyA.setNotifyType(0);
			notifyA.setNotifyFlg(0);

			NotifyRelationInfo notifyB = new NotifyRelationInfo();
			notifyB.setNotifyGroupId("notifyGroup");
			notifyB.setNotifyId("notify2");
			notifyB.setNotifyType(1);
			notifyB.setNotifyFlg(1);

			notifyList2.add(notifyA);
			notifyList2.add(notifyB);
		}
		info2.setNotifyId(notifyList2);

		judge(true,info1.equals(info2));


		System.out.println("*** 「終了状態」のみ違う ***");
		info2 = new JobNotificationsInfo();
		info2.setType(1);
		info2.setPriority(0);
		info2.setNotifyGroupId("notifyGroup");
		notifyList2 = new ArrayList<NotifyRelationInfo>();
		{
			NotifyRelationInfo notifyA = new NotifyRelationInfo();
			notifyA.setNotifyGroupId("notifyGroup");
			notifyA.setNotifyId("notify1");
			notifyA.setNotifyType(0);
			notifyA.setNotifyFlg(0);

			NotifyRelationInfo notifyB = new NotifyRelationInfo();
			notifyB.setNotifyGroupId("notifyGroup");
			notifyB.setNotifyId("notify2");
			notifyB.setNotifyType(1);
			notifyB.setNotifyFlg(1);

			notifyList2.add(notifyA);
			notifyList2.add(notifyB);
		}
		info2.setNotifyId(notifyList2);

		judge(false,info1.equals(info2));

		System.out.println("*** 「重要度」のみ違う ***");
		info2 = new JobNotificationsInfo();
		info2.setType(0);
		info2.setPriority(1);
		info2.setNotifyGroupId("notifyGroup");
		notifyList2 = new ArrayList<NotifyRelationInfo>();
		{
			NotifyRelationInfo notifyA = new NotifyRelationInfo();
			notifyA.setNotifyGroupId("notifyGroup");
			notifyA.setNotifyId("notify1");
			notifyA.setNotifyType(0);
			notifyA.setNotifyFlg(0);

			NotifyRelationInfo notifyB = new NotifyRelationInfo();
			notifyB.setNotifyGroupId("notifyGroup");
			notifyB.setNotifyId("notify2");
			notifyB.setNotifyType(1);
			notifyB.setNotifyFlg(1);

			notifyList2.add(notifyA);
			notifyList2.add(notifyB);
		}
		info2.setNotifyId(notifyList2);

		judge(false,info1.equals(info2));

		System.out.println("*** 「通知グループID」のみ違う ***");
		info2 = new JobNotificationsInfo();
		info2.setType(0);
		info2.setPriority(0);
		info2.setNotifyGroupId("notifyGroup1");
		notifyList2 = new ArrayList<NotifyRelationInfo>();
		{
			NotifyRelationInfo notifyA = new NotifyRelationInfo();
			notifyA.setNotifyGroupId("notifyGroup");
			notifyA.setNotifyId("notify1");
			notifyA.setNotifyType(0);
			notifyA.setNotifyFlg(0);

			NotifyRelationInfo notifyB = new NotifyRelationInfo();
			notifyB.setNotifyGroupId("notifyGroup");
			notifyB.setNotifyId("notify2");
			notifyB.setNotifyType(1);
			notifyB.setNotifyFlg(1);

			notifyList2.add(notifyA);
			notifyList2.add(notifyB);
		}
		info2.setNotifyId(notifyList2);

		judge(false,info1.equals(info2));

		System.out.println("*** 「通知ID」のみ違う ***");
		info2 = new JobNotificationsInfo();
		info2.setType(0);
		info2.setPriority(0);
		info2.setNotifyGroupId("notifyGroup");
		notifyList2 = new ArrayList<NotifyRelationInfo>();
		{
			NotifyRelationInfo notifyA = new NotifyRelationInfo();
			notifyA.setNotifyGroupId("notifyGroup");
			notifyA.setNotifyId("notify1");
			notifyA.setNotifyType(1);
			notifyA.setNotifyFlg(0);

			NotifyRelationInfo notifyB = new NotifyRelationInfo();
			notifyB.setNotifyGroupId("notifyGroup");
			notifyB.setNotifyId("notify2");
			notifyB.setNotifyType(1);
			notifyB.setNotifyFlg(1);

			notifyList2.add(notifyA);
			notifyList2.add(notifyB);
		}
		info2.setNotifyId(notifyList2);

		judge(false,info1.equals(info2));
	}

	public static JobNotificationsInfo createSampleInfo() {
		JobNotificationsInfo info = new JobNotificationsInfo();
		info.setType(0);
		info.setPriority(0);
		info.setNotifyGroupId("notifyGroup");
		ArrayList<NotifyRelationInfo> notifyList1 = new ArrayList<NotifyRelationInfo>();
		{
			NotifyRelationInfo notify1 = new NotifyRelationInfo();
			notify1.setNotifyGroupId("notifyGroup");
			notify1.setNotifyId("notify1");
			notify1.setNotifyType(0);
			notify1.setNotifyFlg(0);

			NotifyRelationInfo notify2 = new NotifyRelationInfo();
			notify2.setNotifyGroupId("notifyGroup");
			notify2.setNotifyId("notify2");
			notify2.setNotifyType(1);
			notify2.setNotifyFlg(1);

			notifyList1.add(notify1);
			notifyList1.add(notify2);
		}
		info.setNotifyId(notifyList1);
		return info;
	}
	/**
	 * 単体テストの結果が正しいものか判断する
	 * @param judge
	 * @param result
	 */
	private static void judge(boolean judge, boolean result){

		System.out.println("expect : " + judge);
		System.out.print("result : " + result);
		String ret = "NG";
		if (judge == result) {
			ret = "OK";
		}
		System.out.println("    is ...  " + ret);
	}
}