package com.clustercontrol.notify.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;


/**
 * The persistent class for the cc_notify_log_escalate_info database table.
 * 
 */
@Entity
@Table(name="cc_notify_log_escalate_info")
@Cacheable(true)
public class NotifyLogEscalateInfoEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private NotifyLogEscalateInfoEntityPK id;
	private Integer escalateFacilityFlg;
	private Integer escalateFlg;
	private String escalateMessage;
	private Integer escalatePort;
	private Integer syslogFacility;
	private Integer syslogPriority;
	private String escalateFacilityId;
	private NotifyInfoEntity notifyInfoEntity;

	@Deprecated
	public NotifyLogEscalateInfoEntity() {
	}

	public NotifyLogEscalateInfoEntity(NotifyLogEscalateInfoEntityPK pk,
			NotifyInfoEntity notifyInfoEntity) {
		this.setId(pk);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.relateToNotifyInfoEntity(notifyInfoEntity);
	}

	public NotifyLogEscalateInfoEntity(String notifyId, Integer priority,
			NotifyInfoEntity notifyInfoEntity) {
		this(new NotifyLogEscalateInfoEntityPK(notifyId, priority), notifyInfoEntity);
	}


	@EmbeddedId
	public NotifyLogEscalateInfoEntityPK getId() {
		return this.id;
	}

	public void setId(NotifyLogEscalateInfoEntityPK id) {
		this.id = id;
	}


	@Column(name="escalate_facility_flg")
	public Integer getEscalateFacilityFlg() {
		return this.escalateFacilityFlg;
	}

	public void setEscalateFacilityFlg(Integer escalateFacilityFlg) {
		this.escalateFacilityFlg = escalateFacilityFlg;
	}


	@Column(name="escalate_flg")
	public Integer getEscalateFlg() {
		return this.escalateFlg;
	}

	public void setEscalateFlg(Integer escalateFlg) {
		this.escalateFlg = escalateFlg;
	}


	@Column(name="escalate_message")
	public String getEscalateMessage() {
		return this.escalateMessage;
	}

	public void setEscalateMessage(String escalateMessage) {
		this.escalateMessage = escalateMessage;
	}


	@Column(name="escalate_port")
	public Integer getEscalatePort() {
		return this.escalatePort;
	}

	public void setEscalatePort(Integer escalatePort) {
		this.escalatePort = escalatePort;
	}


	@Column(name="syslog_facility")
	public Integer getSyslogFacility() {
		return this.syslogFacility;
	}

	public void setSyslogFacility(Integer syslogFacility) {
		this.syslogFacility = syslogFacility;
	}


	@Column(name="syslog_priority")
	public Integer getSyslogPriority() {
		return this.syslogPriority;
	}

	public void setSyslogPriority(Integer syslogPriority) {
		this.syslogPriority = syslogPriority;
	}


	@Column(name="escalate_facility")
	public String getEscalateFacilityId() {
		return this.escalateFacilityId;
	}

	public void setEscalateFacilityId(String escalateFacilityId) {
		this.escalateFacilityId = escalateFacilityId;
	}


	//bi-directional many-to-one association to NotifyInfoEntity
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="notify_id", insertable=false, updatable=false)
	public NotifyInfoEntity getNotifyInfoEntity() {
		return this.notifyInfoEntity;
	}

	@Deprecated
	public void setNotifyInfoEntity(NotifyInfoEntity notifyInfoEntity) {
		this.notifyInfoEntity = notifyInfoEntity;
	}

	/**
	 * NotifyInfoEntityオブジェクト参照設定<BR>
	 * 
	 * NotifyInfoEntity設定時はSetterに代わりこちらを使用すること。
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void relateToNotifyInfoEntity(NotifyInfoEntity notifyInfoEntity) {
		this.setNotifyInfoEntity(notifyInfoEntity);
		if (notifyInfoEntity != null) {
			List<NotifyLogEscalateInfoEntity> list = notifyInfoEntity.getNotifyLogEscalateInfoEntities();
			if (list == null) {
				list = new ArrayList<NotifyLogEscalateInfoEntity>();
			} else {
				for(NotifyLogEscalateInfoEntity entity : list){
					if (entity.getId().equals(this.getId())) {
						return;
					}
				}
			}
			list.add(this);
			notifyInfoEntity.setNotifyLogEscalateInfoEntities(list);
		}
	}

	/**
	 * 削除前処理<BR>
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void unchain() {

		// NotifyInfoEntity
		if (this.notifyInfoEntity != null) {
			List<NotifyLogEscalateInfoEntity> list = this.notifyInfoEntity.getNotifyLogEscalateInfoEntities();
			if (list != null) {
				Iterator<NotifyLogEscalateInfoEntity> iter = list.iterator();
				while(iter.hasNext()) {
					NotifyLogEscalateInfoEntity entity = iter.next();
					if (entity.getId().equals(this.getId())){
						iter.remove();
						break;
					}
				}
			}
		}
	}

}