/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.factory;

import java.sql.Timestamp;
import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.snmptrap.entity.SnmpTrapMibMasterData;
import com.clustercontrol.snmptrap.model.SnmpTrapMibMstEntity;
import com.clustercontrol.snmptrap.util.QueryUtil;

/**
 *　MIBマスター情報を変更するクラス<BR>
 *
 * @version 3.0.0
 * @since 2.4.0
 * @author Yosuke
 */
public class ModifyMibMaster {

	private static Log m_log = LogFactory.getLog( ModifyMibMaster.class );

	/** 監視情報ビーン */
	private SnmpTrapMibMasterData m_MibData;

	/**
	 * MIBマスター情報を変更します。
	 * 
	 * @param MibData　変更するマスター情報
	 * @param user　変更実行ユーザ
	 * @return
	 * @throws MonitorNotFound
	 */
	public boolean modify(SnmpTrapMibMasterData mibData, String user) throws MonitorNotFound {

		m_MibData = mibData;

		boolean result = false;
		// 監視情報を登録
		result = modifyMibMaster(user);

		return result;
	}

	/**
	 * MIBマスター情報の変更を行う。
	 * @param user　変更実行ユーザ
	 * 
	 * @return
	 * @throws MonitorNotFound
	 */
	public boolean modifyMibMaster(String user) throws MonitorNotFound {
		boolean result = false;

		Timestamp now = new Timestamp(new Date().getTime());

		// 監視情報を検索
		SnmpTrapMibMstEntity entity = QueryUtil.getSnmpTrapMibMstPK(m_MibData.getMib());

		entity.setDescription(m_MibData.getDescription());
		entity.setOrderNo(m_MibData.getOrderNo());
		entity.setUpdateDate(now);
		entity.setUpdateUser(user);

		result = true;

		return result;
	}
}
