/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.aws.base.ui.views.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.aws.base.resources.GroupIdentifier;
import com.clustercontrol.cloud.aws.base.ui.dialogs.CreateInstanceDialog;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceByTemplateRequest;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceRequest;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.presenter.IAccountResource.IRegion;
import com.clustercontrol.cloud.ui.views.InstanceMonitorService;
import com.clustercontrol.cloud.ui.views.TemplatesView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;


public class CreateInstanceByTemplateAction extends SingleSelectionActionEx {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String msgCreateInstanceConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.instance", "word.create"});
	private String msgCreateInstanceResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.instance", "word.create"});

	private ICloudTemplateManager templateManager;
	private ICloudTemplate template;
	
	@Override
	protected void invoke(IAction action) throws InvocationException {
		CreateInstanceDialog dialog = new CreateInstanceDialog(this.viewPart.getSite().getShell());

		final TemplatesView view = (TemplatesView)viewPart;

		template = (ICloudTemplate)((IStructuredSelection)viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		templateManager = template.getCloudTemplateManager();
		String region = template.getRegion();
		CreateInstanceDialog.Model input = new CreateInstanceDialog.Model();
		input.setRegionName(region);
		dialog.setInput(input);
		dialog.setCloudTemplateManager(templateManager);

		dialog.setCloudInfoProvider(new CloudResourceProviderImpl(view.getAccountResource().getAccountResourceId()));
		dialog.setBehavior(new CreateInstanceDialog.DialogBehavior(){
			private Combo region;

			@Override
			public void setupRegion(Combo region) {
				for (String regionName: provider.getAllRegion()) {
					String regionLocaleName = messages.getString(regionName);
					region.add(regionLocaleName);
					region.setData(regionLocaleName, regionName);
				}
				if (template != null && template.getRegion() != null) {
					String regionLocaleName = messages.getString(input.getRegionName());
					region.select(region.indexOf(regionLocaleName));
				} else {
					region.select(0);
				}
				this.region = region;
			}

			@Override
			public void setupAvailabilityZone(Combo availabilityZone) {
				for (AvailabilityZone zone: provider.getAvailabilityZones((String)region.getData(region.getText()))) {
					availabilityZone.add(zone.getZoneName());
				}
				availabilityZone.select(0);
			}

			@Override
			public void setupKeyPair(Combo keyPair) {
				for(String keyName: provider.getKeyNames((String)region.getData(region.getText()))){
					keyPair.add(keyName);
				}
				if(keyPair.getItemCount() > 0){
					keyPair.setEnabled(true);
					keyPair.select(0);
				}
				else {
					keyPair.setEnabled(false);
				}
			}

			@Override
			public void setupSelectImageFlg(Button rdoAmi, Button rdoTemplate){
				rdoAmi.setSelection(false);
				rdoTemplate.setSelection(true);
			}

			@Override
			public void setupAmi(Text ami, Button selectAmi){
				ami.setEnabled(false);
				ami.setEditable(false);
				ami.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				selectAmi.setEnabled(false);
			}

			@Override
			public void setupTemplate(Button useTemplate, Combo template, Button editArgument){
				useTemplate.setSelection(true);
				Map<String, String> map = new HashMap<String, String>();
				for(ICloudTemplate tmpTemplate: templateManager.getCloudTemplates()){
					if(tmpTemplate.getRegion().equals(region.getData(region.getText()))){
						String tmpLabel = tmpTemplate.getTemplateName() + " ( " + tmpTemplate.getTemplateId() + " )";
						template.add(tmpLabel);
						template.setData(tmpLabel, tmpTemplate);
						map.put(tmpTemplate.getTemplateId(), tmpLabel);
					}
				}
				if(CreateInstanceByTemplateAction.this.template != null && map.containsKey(CreateInstanceByTemplateAction.this.template.getTemplateId())){
					template.select(template.indexOf(map.get(CreateInstanceByTemplateAction.this.template.getTemplateId())));
				}
				template.setEnabled(true);
				editArgument.setEnabled(true);
			}
		});

		if(dialog.open() == Window.OK){
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgCreateInstanceConfirm)){

				CreateInstanceDialog.Model m = dialog.getOutput();

				IRegion r = templateManager.getAccountResource().getRegion(template.getRegion());
				final ICloudInstance instance;

				CreateInstanceDialog.InstanceDetail detail = new CreateInstanceDialog.InstanceDetail();

				if(m.getSubnet() != null){
					detail.subnetId = m.getSubnet().getSubnetId();
				} else {
					detail.subnetId = null;
				}
				detail.keyName = m.getKeyName();
				detail.monitoring = m.getMonitoring();
				detail.disableApiTermination = m.getDisableApiTermination();
				detail.instanceInitiatedShutdownBehavior = m.getInstanceInitiatedShutdownBehavior();
				detail.ebsOptimized = m.getEbsOptimized();
				if(m.getRootBlockDevice() != null){
					detail.rootBlockDevice = new CreateInstanceDialog.EbsBlockDevice();
					detail.rootBlockDevice.volumeSize = m.getRootBlockDevice().volumeSize;
					detail.rootBlockDevice.volumeType = m.getRootBlockDevice().volumeType;
					detail.rootBlockDevice.deleteOnTermination = m.getRootBlockDevice().deleteOnTermination;
				} else {
//					detail.rootBlockDevice = new CreateInstanceDialog.EbsBlockDevice();
//					detail.rootBlockDevice.volumeSize = 10;
//					detail.rootBlockDevice.volumeType = "standard";
//					detail.rootBlockDevice.deleteOnTermination = true;
				}
				
				if(m.getSecurityGroups() != null){
					detail.securityGroupIds = new ArrayList<>();
					for(GroupIdentifier securityGroup: m.getSecurityGroups()){
						detail.securityGroupIds.add(securityGroup.getGroupId());
					}
				} else {
//					detail.securityGroupIds = new ArrayList<>();
//					detail.securityGroupIds.add("hinemos-agent-nonVPC");
				}
				
				ObjectMapper om = new ObjectMapper();
				ObjectWriter dw = om.writerWithType(CreateInstanceDialog.InstanceDetail.class);
				String detailJson;
				try {
					detailJson = dw.writeValueAsString(detail);
				} catch (Exception e) {
					throw new CloudModelException(e);
				}

				if(m.isTemplateUsed()){
					CreateCloudInstanceByTemplateRequest request = new CreateCloudInstanceByTemplateRequest();

					request.setZone(m.getZone());
					
					request.setTemplateId(m.getTemplateId());
					
					request.setFlavor(m.getFlavor());
					
					request.setFacilityId(m.getFacilityId());
					request.setFacilityName(m.getFacilityName());
					request.setDescription(m.getDescription());
					request.setNodeName(m.getNodeName());
					request.setReplaceNode(m.getReplaceNode());
					
					request.setArguments(m.getArguments());
					request.setTags(m.getTags());
					
					request.setInstanceDetail(detailJson);
					
					instance = r.getAccountResource().getRegion(m.getRegionName()).getCloudService(ICloudComputeService.class).getInstanceManager().createCloudInstanceByTemplate(request);
				} else {
					CreateCloudInstanceRequest request = new CreateCloudInstanceRequest();

					request.setZone(m.getZone());
					if(m.getImage() != null){
						request.setImageId(m.getImage().getImageId());
					}
					request.setFlavor(m.getFlavor());
					
					request.setFacilityId(m.getFacilityId());
					request.setFacilityName(m.getFacilityName());
					request.setDescription(m.getDescription());
					request.setNodeName(m.getNodeName());
					request.setReplaceNode(m.getReplaceNode());
					
					request.setInstanceDetail(detailJson);
					
					instance = r.getAccountResource().getRegion(m.getRegionName()).getCloudService(ICloudComputeService.class).getInstanceManager().createCloudInstance(request);
				}

				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgCreateInstanceResult);
				
				view.getSite().getShell().getDisplay().asyncExec(new Runnable() {
					@Override
					public void run() {
						InstanceMonitorService.getInstanceMonitorService().startMonitor(instance, ICloudInstance.StateType.running, ICloudInstance.StateType.terminated, ICloudInstance.StateType.stopped);
						com.clustercontrol.action.FacilityTree.refresh();
					}
				});
			}
			else {
				return;
			}
		}
	}
}