/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.aws.base.ui.views.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.aws.base.resources.Filter;
import com.clustercontrol.cloud.aws.base.resources.Image;
import com.clustercontrol.cloud.aws.base.ui.dialogs.CreateTemplateDialog;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.ModifyCloudTemplateRequest;
import com.clustercontrol.cloud.ui.views.TemplatesView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;


public class ModifyTemplateAction extends SingleSelectionActionEx {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String msgModifyTemplateConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.template", "word.modify"});
	private String msgModifyTemplateResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.template", "word.modify"});

	private CloudResourceProvider provider;
	private ICloudTemplate template;
	
	@Override
	protected void invoke(IAction action) throws InvocationException {
		template = (ICloudTemplate)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		final IAccountResource accountResource = ((TemplatesView)viewPart).getAccountResource();
		provider = new CloudResourceProviderImpl(accountResource.getAccountResourceId());
		CreateTemplateDialog dialog = new CreateTemplateDialog(this.viewPart.getSite().getShell());
		dialog.setCloudInfoProvider(provider);
		try {
			dialog.setBehavior(new CreateTemplateDialog.DialogBehavior(){

				private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
				private List<TemplateJobUtil.TemplateJobnet> templateJobs;
				{
					try{
						templateJobs = TemplateJobUtil.getTemplateJobList(accountResource.getAccountResourceId(), true);
					} catch(com.clustercontrol.ws.jobmanagement.InvalidRole_Exception e) {
						MessageDialog.openError(null, Messages.getString("failed"), e.getMessage());
						templateJobs = new ArrayList<TemplateJobUtil.TemplateJobnet>();
					}
				}
								
				@Override
				public void setupTemplateId(Text templateId) {
					if(template != null){
						templateId.setText(template.getTemplateId());
						templateId.setEditable(false);
					}
				}

				@Override
				public void setupTemplateName(Text templateName) {
					if(template != null && template.getTemplateName() != null && !template.getTemplateName().isEmpty()){
						templateName.setText(template.getTemplateName());
					}
				}
				@Override
				public void setupRegion(Combo region) {
					for (String regionName: provider.getAllRegion()) {
						String regionLocaleName = messages.getString(regionName);
						region.add(regionLocaleName);
						region.setData(regionLocaleName, regionName);
					}
					if (template != null && template.getRegion() != null && !template.getRegion().equals("")) {
						String regionLocaleName = messages.getString(template.getRegion());
						region.select(region.indexOf(regionLocaleName));
					} else {
						region.select(0);
					}
				}
				
				@Override
				public void setupAmi(Text ami, Button selectAmi) {
					if(template != null && template.getImageId() != null && !template.getImageId().equals("") && template.getRegion() != null && !template.getRegion().equals("")){
						Filter f1 = new Filter();
						f1.setName("image-id");
						f1.setValues(Arrays.asList(template.getImageId()));
	
						List<Image> imageList = provider.getImages(template.getRegion(), Arrays.asList(f1));
						if (!imageList.isEmpty()) {
							Image image = imageList.get(0);
							ami.setText("(" + image.getImageId() + ") "+ image.getName());
							ami.setData(image);
						}
					}
				}

				@Override
				public void setupLaunchJobId(Combo launchJobId){
					launchJobId.add("");
					Map<String, String> tmpMap = new HashMap<String, String>();
					for(TemplateJobUtil.TemplateJobnet childJobItem : templateJobs){
						String jobId = childJobItem.getJobnetId();
						String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
						tmpMap.put(jobId, jobName);
						launchJobId.add(jobName);
						launchJobId.setData(jobName, jobId);
					}
					if(template != null && template.getLaunchJobId() != null && !template.getLaunchJobId().equals("") && tmpMap.containsKey(template.getLaunchJobId())){
						launchJobId.select(launchJobId.indexOf(tmpMap.get(template.getLaunchJobId())));
					}
				}

				@Override
				public void setupStartJobId(Combo startJobId) {
					startJobId.add("");
					Map<String, String> tmpMap = new HashMap<String, String>();
					for(TemplateJobUtil.TemplateJobnet childJobItem : templateJobs){
						String jobId = childJobItem.getJobnetId();
						String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
						tmpMap.put(jobId, jobName);
						startJobId.add(jobName);
						startJobId.setData(jobName, jobId);
					}
					if(template != null && template.getStartJobId() != null && !template.getStartJobId().equals("") && tmpMap.containsKey(template.getStartJobId())){
						startJobId.select(startJobId.indexOf(tmpMap.get(template.getStartJobId())));
					}
				}

				@Override
				public void setupStopJobId(Combo stopJobId) {
					stopJobId.add("");
					Map<String, String> tmpMap = new HashMap<String, String>();
					for(TemplateJobUtil.TemplateJobnet childJobItem : templateJobs){
						String jobId = childJobItem.getJobnetId();
						String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
						tmpMap.put(jobId, jobName);
						stopJobId.add(jobName);
						stopJobId.setData(jobName, jobId);
					}
					if(template != null && template.getStopJobId() != null && !template.getStopJobId().equals("") && tmpMap.containsKey(template.getStopJobId())){
						stopJobId.select(stopJobId.indexOf(tmpMap.get(template.getStopJobId())));
					}
				}
			});
		} catch (Exception e) {
			throw new InvocationException(e);
		}

		if (dialog.open() == Window.OK) {
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgModifyTemplateConfirm)) {

				ModifyCloudTemplateRequest request = new ModifyCloudTemplateRequest();

				request.setImageId(dialog.getOutput().getImageId());
				request.setJobUnitId(template.getJobUnitId());
				request.setLaunchJobId(dialog.getOutput().getLaunchJobId());
				request.setStartJobId(dialog.getOutput().getStartJobId());
				request.setStopJobId(dialog.getOutput().getStopJobId());
				request.setRegion(dialog.getOutput().getRegion());
				request.setTemplateId(dialog.getOutput().getTemplateId());
				request.setTemplateName(dialog.getOutput().getTemplateName());
				
				template.modifyCloudTemplate(request);
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgModifyTemplateResult);
			}
			else {
				return;
			}
		}
	}
}