/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.registry;

import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.persistence.PersistenceUtil;
import com.clustercontrol.cloud.persistence.Transactional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectRegistryService {
    private static IObjectRegistry singleton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IObjectRegistry registry() {
        if (singleton != null) return singleton;
        Class<ObjectRegistryService> clazz = ObjectRegistryService.class;
        synchronized (ObjectRegistryService.class) {
            if (singleton != null) return singleton;
            singleton = new ObjectRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private static class ObjectRegistry
    implements IObjectRegistry {
        public static final Object nullKey = new Object();
        private Map<Class<?>, Map<Object, Object>> objectMap = Collections.synchronizedMap(new HashMap());

        private ObjectRegistry() {
        }

        @Override
        public <T> void put(Class<T> interfaceClass, Object key, Class<? extends T> implementor) {
            this.internalPut(interfaceClass, key, implementor);
        }

        @Override
        public <T> void put(Class<T> interfaceClass, Class<? extends T> implementor) {
            this.internalPut(interfaceClass, nullKey, implementor);
        }

        @Override
        public <T> T get(Class<T> interfaceClass, Object key) {
            Map<Object, Object> map = this.objectMap.get(interfaceClass);
            if (map == null) {
                return null;
            }
            Object obj = map.get(key);
            if (obj == null) {
                return null;
            }
            T implementer = this.object(interfaceClass, key, obj);
            Transactional t = implementer.getClass().getAnnotation(Transactional.class);
            if (t != null) {
                return (T)PersistenceUtil.decorateTransactional(interfaceClass, implementer);
            }
            return interfaceClass.cast(implementer);
        }

        @Override
        public <T> T get(Class<T> interfaceClass) {
            return this.get(interfaceClass, nullKey);
        }

        private <T> T object(Class<T> interfaceClass, Object key, Object obj) {
            if (obj instanceof IProvider) {
                return interfaceClass.cast(((IProvider)obj).provide(key));
            }
            if (obj instanceof Class) {
                try {
                    return interfaceClass.cast(((Class)obj).newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new InternalManagerError(e);
                }
            }
            return interfaceClass.cast(obj);
        }

        @Override
        public <T> void put(Class<T> interfaceClass, IProvider<? extends T> provider) {
            this.internalPut(interfaceClass, nullKey, provider);
        }

        @Override
        public <T> void put(Class<T> interfaceClass, Object key, IProvider<? extends T> provider) {
            this.internalPut(interfaceClass, key, provider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> List<Entry<T>> getAll(Class<T> interfaceClass) {
            Map<Object, Object> map = this.objectMap.get(interfaceClass);
            if (map == null) {
                return null;
            }
            ArrayList<Entry<T>> list = new ArrayList<Entry<T>>();
            Map<Object, Object> map2 = map;
            synchronized (map2) {
                for (Map.Entry<Object, Object> entry : map.entrySet()) {
                    list.add(new Entry<T>(entry.getKey(), this.object(interfaceClass, entry.getKey(), entry.getValue())));
                }
            }
            return list;
        }

        @Override
        public <T> void put(Class<T> interfaceClass, Object key, T implementor) {
            this.internalPut(interfaceClass, key, implementor);
        }

        @Override
        public <T> void put(Class<T> interfaceClass, T implementor) {
            this.internalPut(interfaceClass, nullKey, implementor);
        }

        private void internalPut(Class<?> interfaceClass, Object key, Object implementor) {
            Map<Object, Object> map = this.objectMap.get(interfaceClass);
            if (map == null) {
                map = new HashMap<Object, Object>();
                this.objectMap.put(interfaceClass, Collections.synchronizedMap(map));
            }
            map.put(key, implementor);
        }
    }

    public static interface IObjectRegistry {
        public <T> void put(Class<T> var1, Object var2, Class<? extends T> var3);

        public <T> void put(Class<T> var1, Class<? extends T> var2);

        public <T> void put(Class<T> var1, IProvider<? extends T> var2);

        public <T> void put(Class<T> var1, Object var2, IProvider<? extends T> var3);

        public <T> void put(Class<T> var1, Object var2, T var3);

        public <T> void put(Class<T> var1, T var2);

        public <T> T get(Class<T> var1, Object var2);

        public <T> T get(Class<T> var1);

        public <T> List<Entry<T>> getAll(Class<T> var1);
    }

    public static interface IProvider<T> {
        public T provide(Object var1);
    }

    public static class Entry<T> {
        private Object key;
        private T implementor;

        public Entry(Object key, T implementor) {
            this.key = key;
            this.implementor = implementor;
        }

        public Object getKey() {
            return this.key;
        }

        public T getImplementor() {
            return this.implementor;
        }
    }
}

