/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.ICloudContext;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudRegion;
import com.clustercontrol.cloud.bean.CloudService;
import com.clustercontrol.cloud.bean.CloudType;
import com.clustercontrol.cloud.bean.Zone;
import com.clustercontrol.cloud.dao.CloudRegionDao;
import com.clustercontrol.cloud.dao.CloudServiceDao;
import com.clustercontrol.cloud.dao.CloudTypeDao;
import com.clustercontrol.cloud.factory.ICloudServiceOperator;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.persistence.IDHolder;
import com.clustercontrol.cloud.persistence.Transactional;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityExistsException;

@Transactional
public class CloudServiceOperator
implements ICloudServiceOperator {
    @Override
    public List<CloudType> findAllCloudTypes() throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        List csds = em.findAll(CloudTypeDao.class);
        ArrayList<CloudType> css = new ArrayList<CloudType>();
        for (CloudTypeDao d : csds) {
            css.add(new CloudType(d));
        }
        return css;
    }

    @Override
    public CloudService createCloudService(CloudService cs) throws CloudManagerFault {
        CloudServiceDao cud = new CloudServiceDao(cs.getTableData());
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        try {
            em.persist((IDHolder)cud);
            return new CloudService(cud);
        }
        catch (EntityExistsException e) {
            throw ErrorCode.CLOUDSERVICE_ALREADY_EXIST.cloudManagerFault(cud.getCloudServiceId());
        }
    }

    @Override
    public CloudService modifyCloudService(CloudService cu) throws CloudManagerFault {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeCloudService(String cloudServiceId) throws CloudManagerFault {
        throw new UnsupportedOperationException();
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public CloudService findCloudService(String cloudServiceId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudServiceDao dao = (CloudServiceDao)em.find(CloudServiceDao.class, (Object)cloudServiceId);
        if (dao == null) {
            throw ErrorCode.CLOUDSERVICE_INVALID_CLOUDSERVICE_NOT_FOUND.cloudManagerFault(cloudServiceId);
        }
        return new CloudService(dao);
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public List<CloudService> findAllCloudService() throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        List csds = em.findAll(CloudServiceDao.class);
        ArrayList<CloudService> css = new ArrayList<CloudService>();
        for (CloudServiceDao d : csds) {
            css.add(new CloudService(d));
        }
        return css;
    }

    @Override
    public CloudRegion addCloudRegion(String cloudServiceId, CloudRegion cu) throws CloudManagerFault {
        throw new UnsupportedOperationException();
    }

    @Override
    public CloudRegion modifyCloudRegion(String cloudServiceId, CloudRegion cu) throws CloudManagerFault {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeCloudRegion(String cloudServiceId, String cloudRegionId) throws CloudManagerFault {
        throw new UnsupportedOperationException();
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public CloudRegion findCloudRegion(String cloudServiceId, String region) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudRegionDao dao = (CloudRegionDao)em.find(CloudRegionDao.class, (Object)new CloudRegionDao.CloudRegionPK(cloudServiceId, region));
        if (dao == null) {
            throw ErrorCode.CLOUDREGION_INVALID_CLOUDREGION_NOT_FOUND.cloudManagerFault(cloudServiceId, region);
        }
        return new CloudRegion(dao);
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public List<CloudRegion> findCloudRegionsByService(String cloudServiceId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        List crds = em.findByFilter(CloudRegionDao.class, new Filter[]{new Filter("cloudServiceId", new String[]{cloudServiceId})});
        ArrayList<CloudRegion> crs = new ArrayList<CloudRegion>();
        for (CloudRegionDao d : crds) {
            crs.add(new CloudRegion(d));
        }
        return crs;
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public List<Zone> findZonesByRegion(String cloudServiceId, String region) throws CloudManagerFault {
        CloudService cloudService = this.findCloudService(cloudServiceId);
        final CloudRegion cloudRegion = this.findCloudRegion(cloudServiceId, region);
        IResourceManagement rm = (IResourceManagement)ObjectRegistryService.registry().get(IResourceManagement.class, (Object)cloudService.getCloudTypeId());
        rm.setAccessDestination(new IResourceManagement.ICredential(){

            @Override
            public String getSecretKey() throws CloudManagerFault {
                return ((ICloudContext)SessionService.current().get(ICloudContext.class)).getAccessDestionation().getCloudUser().getSecretKey();
            }

            @Override
            public String getAccessKey() throws CloudManagerFault {
                return ((ICloudContext)SessionService.current().get(ICloudContext.class)).getAccessDestionation().getCloudUser().getAccessKey();
            }
        }, new IResourceManagement.IRegion(){

            @Override
            public String getName() {
                return cloudRegion.getRegion();
            }

            @Override
            public IResourceManagement.IEndpoint getEndpoint(final String type) {
                final String locatio = cloudRegion.getEndpoint(type).getLocation();
                if (locatio != null) {
                    return new IResourceManagement.IEndpoint(){

                        @Override
                        public String getEndpointType() {
                            return type;
                        }

                        @Override
                        public String getLocation() {
                            return locatio;
                        }
                    };
                }
                throw new InternalManagerError();
            }
        });
        return rm.getZones();
    }
}

