/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.CreateCloudUserRequest;
import com.clustercontrol.cloud.bean.ModifyCloudUserRequest;
import com.clustercontrol.cloud.dao.CloudAccountResourceDao;
import com.clustercontrol.cloud.dao.CloudUserDao;
import com.clustercontrol.cloud.factory.ICloudUserOperator;
import com.clustercontrol.cloud.factory.RemovedEventNotifier;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.persistence.IDHolder;
import com.clustercontrol.cloud.persistence.Transactional;
import com.clustercontrol.cloud.registry.IObjectChangedService;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.fault.InvalidRole;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityExistsException;
import javax.persistence.NoResultException;
import javax.persistence.Query;

@Transactional
public class CloudUserOperator
implements ICloudUserOperator {
    @Override
    public CloudUser createCloudAccount(CreateCloudUserRequest request) throws CloudManagerFault {
        return this.createInternalCloudUser(request, CloudUserDao.CloudUserType.account);
    }

    @Override
    public CloudUser createCloudUser(CreateCloudUserRequest request) throws CloudManagerFault {
        return this.createInternalCloudUser(request, CloudUserDao.CloudUserType.user);
    }

    private CloudUser createInternalCloudUser(CreateCloudUserRequest request, CloudUserDao.CloudUserType type) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudAccountResourceDao arDao = (CloudAccountResourceDao)em.find(CloudAccountResourceDao.class, (Object)request.getAccountResourceId());
        if (arDao == null) {
            throw ErrorCode.ACCOUNTRESOURCE_INVALID_ACCOUNTRESOURCE_NOT_FOUND.cloudManagerFault(request.getAccountResourceId());
        }
        CloudUserDao cud = new CloudUserDao();
        cud.setCloudUserId(request.getCloudUserId());
        cud.setCloudUserName(request.getCloudUserName());
        cud.setAccountResource(arDao);
        cud.setCloudUserType(type);
        cud.setDescription(request.getDescription());
        cud.setAccessKey(request.getAccessKey());
        cud.setSecretKey(request.getSecretKey());
        cud.setRoleId(request.getRoleId());
        CloudUser cu = null;
        try {
            em.persist((IDHolder)cud);
            cu = new CloudUser(cud);
        }
        catch (EntityExistsException e) {
            throw ErrorCode.CLOUDUSER_ALREADY_EXIST.cloudManagerFault(cud.getCloudUserId());
        }
        try {
            ((IObjectChangedService)ObjectRegistryService.registry().get(IObjectChangedService.class)).firePostAddedEvent(null, CloudUser.class, (Object)cu);
            return cu;
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
    }

    @Override
    public void removeCloudUser(String cloudUserId) throws CloudManagerFault, InvalidRole {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudUserDao dao = (CloudUserDao)em.find(CloudUserDao.class, (Object)cloudUserId);
        if (dao == null) {
            throw ErrorCode.CLOUDUSER_NOT_FOUND.cloudManagerFault(cloudUserId);
        }
        if (dao.getCloudUserType() == CloudUserDao.CloudUserType.account) {
            dao.getAccountResource().setAccount(null);
        }
        try (RemovedEventNotifier<CloudUser> notifier = new RemovedEventNotifier<CloudUser>(null, CloudUser.class, new CloudUser(dao));){
            em.remove((Object)dao);
            notifier.setCompleted();
        }
    }

    @Override
    public CloudUser modifyCloudUser(ModifyCloudUserRequest request) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudUserDao cud = (CloudUserDao)em.find(CloudUserDao.class, (Object)request.getCloudUserId());
        if (cud == null) {
            throw ErrorCode.CLOUDUSER_NOT_FOUND.cloudManagerFault(request.getCloudUserId());
        }
        if (request.getCloudUserName() != null) {
            cud.setCloudUserName(request.getCloudUserName());
        }
        if (request.getDescription() != null) {
            cud.setDescription(request.getDescription());
        }
        if (request.getAccessKey() != null) {
            cud.setAccessKey(request.getAccessKey());
        }
        if (request.getSecretKey() != null) {
            cud.setSecretKey(request.getSecretKey());
        }
        return new CloudUser(cud);
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public CloudUser findCloudUser(String cloudUserId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudUserDao cud = (CloudUserDao)em.find(CloudUserDao.class, (Object)cloudUserId);
        if (cud == null) {
            throw ErrorCode.CLOUDUSER_NOT_FOUND.cloudManagerFault(cloudUserId);
        }
        return new CloudUser(cud);
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public List<CloudUser> findCloudUserByAccountResource(String accountResourceId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        List culs = em.findByFilter(CloudUserDao.class, new Filter[]{new Filter("accountResource.accountResourceId", new String[]{accountResourceId})});
        ArrayList<CloudUser> cus = new ArrayList<CloudUser>();
        for (CloudUserDao cud : culs) {
            cus.add(new CloudUser(cud));
        }
        return cus;
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public List<CloudUser> findCloudUserByAccountResourceAndUserId(String accountResourceId, String hinemosUserId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        Query query = em.createQuery("SELECT DISTINCT c FROM CloudUserDao c JOIN c.accountResource a JOIN RoleEntity r ON c.roleId = r.roleId WHERE c.accountResource.accountResourceId = :accountResourceId AND (:userId IN (SELECT u.userId FROM r.userEntities u) OR EXISTS (SELECT u FROM UserEntity u JOIN u.roleEntities r WHERE u.userId = :userId AND r.roleId = :ADMINISTRATORS) OR EXISTS (SELECT c FROM CloudUserDao c JOIN c.accountResource a JOIN RoleEntity r ON c.roleId = r.roleId JOIN r.userEntities u WHERE u.userId = :userId AND c.accountResource.accountResourceId = :accountResourceId AND c.cloudUserId = c.accountResource.account.cloudUserId))");
        query.setParameter("accountResourceId", (Object)accountResourceId);
        query.setParameter("userId", (Object)SessionService.current().getHinemosCredential().getUserId());
        query.setParameter("ADMINISTRATORS", (Object)"ADMINISTRATORS");
        List culs = query.getResultList();
        ArrayList<CloudUser> cus = new ArrayList<CloudUser>();
        for (CloudUserDao cud : culs) {
            cus.add(new CloudUser(cud));
        }
        return cus;
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public CloudUser findCloudUserByUserIdAndRoleId(String hinemosUserId, String roleId) throws CloudManagerFault {
        try {
            EntityManagerEx em = SessionService.current().getEntityManagerEx();
            Query query = em.createQuery("SELECT c FROM UserEntity u JOIN u.roleEntities r JOIN CloudUserDao AS c ON c.roleId = r.roleId WHERE u.userId = :userId AND r.roleId = :roleId");
            query.setParameter("userId", (Object)hinemosUserId);
            query.setParameter("roleId", (Object)roleId);
            return new CloudUser((CloudUserDao)query.getSingleResult());
        }
        catch (NoResultException e) {
            throw ErrorCode.CLOUDUSER_INVALID_NOT_RELAITED_HINEMOS_ACCOUNT.cloudManagerFault(hinemosUserId, roleId);
        }
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public CloudUser findCloudUserByRoleId(String roleId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        List cuds = em.findByFilter(CloudUserDao.class, new Filter[]{new Filter("roleId", new String[]{roleId})});
        if (cuds.isEmpty()) {
            throw ErrorCode.CLOUDUSER_NOT_FOUND.cloudManagerFault(roleId);
        }
        return new CloudUser((CloudUserDao)cuds.get(0));
    }

    @Override
    @Transactional(value=Transactional.TransactionType.Supported)
    public List<CloudUser> findAllCloudUser() throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        List culs = em.findAll(CloudUserDao.class);
        ArrayList<CloudUser> cus = new ArrayList<CloudUser>();
        for (CloudUserDao cud : culs) {
            cus.add(new CloudUser(cud));
        }
        return cus;
    }
}

