/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudTemplate;
import com.clustercontrol.cloud.bean.CreateTemplateRequest;
import com.clustercontrol.cloud.bean.ModifyTemplateRequest;
import com.clustercontrol.cloud.commons.CloudConstants;
import com.clustercontrol.cloud.commons.CloudPropertyConstants;
import com.clustercontrol.cloud.dao.CloudTemplateDao;
import com.clustercontrol.cloud.factory.ITemplateOperator;
import com.clustercontrol.cloud.factory.ResourceOperatorBase;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.persistence.IDHolder;
import com.clustercontrol.cloud.persistence.Transactional;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityExistsException;

@Transactional
public class TemplateOperator
extends ResourceOperatorBase
implements ITemplateOperator,
CloudConstants {
    @Override
    public CloudTemplate createTemplate(CreateTemplateRequest request) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudTemplateDao dao = new CloudTemplateDao();
        dao.setTemplateId(request.getTemplateId());
        dao.setCloudServiceId(this.getCloudService().getCloudServiceId());
        dao.setRegion(request.getRegion());
        dao.setAccountResourceId(this.getAccountResource().getAccountResourceId());
        dao.setTemplateName(request.getTemplateName());
        dao.setCloudUserId(this.getCloudUser().getCloudUserId());
        dao.setJobUnitId(this.getAccountResource().getAccountResourceId());
        dao.setImageId(request.getImageId());
        dao.setStartJobId(request.getStartJobId());
        dao.setLaunchJobId(request.getLaunchJobId());
        dao.setStopJobId(request.getStopJobId());
        try {
            em.persist((IDHolder)dao);
        }
        catch (EntityExistsException e) {
            throw ErrorCode.CLOUDTEMPLATE_ALREADY_EXIST.cloudManagerFault(request.getTemplateId());
        }
        return new CloudTemplate(dao, this.getCloudService().getCloudTypeId());
    }

    @Override
    public CloudTemplate modifyTemplate(ModifyTemplateRequest request) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudTemplateDao dao = (CloudTemplateDao)em.find(CloudTemplateDao.class, (Object)request.getTemplateId());
        if (dao == null) {
            throw ErrorCode.CLOUDUSER_NOT_FOUND.cloudManagerFault(request.getTemplateId());
        }
        if (request.getTemplateName() != null) {
            dao.setTemplateName(request.getTemplateName());
        }
        if (request.getRegion() != null) {
            dao.setRegion(request.getRegion());
        }
        if (request.getImageId() != null) {
            dao.setImageId(request.getImageId());
        }
        if (!"".equals(request.getStartJobId())) {
            dao.setStartJobId(request.getStartJobId());
        } else {
            dao.setStartJobId(null);
        }
        if (!"".equals(request.getLaunchJobId())) {
            dao.setLaunchJobId(request.getLaunchJobId());
        } else {
            dao.setLaunchJobId(null);
        }
        if (!"".equals(request.getStopJobId())) {
            dao.setStopJobId(request.getStopJobId());
        } else {
            dao.setStopJobId(null);
        }
        return new CloudTemplate(dao, this.getCloudService().getCloudTypeId());
    }

    @Override
    public void removeTemplate(String templateId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudTemplateDao dao = (CloudTemplateDao)em.find(CloudTemplateDao.class, (Object)templateId);
        if (dao == null) {
            throw ErrorCode.CLOUDUSER_NOT_FOUND.cloudManagerFault(templateId);
        }
        em.remove((Object)dao);
    }

    @Override
    public CloudTemplate findTemplate(String templateId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        CloudTemplateDao dao = (CloudTemplateDao)em.find(CloudTemplateDao.class, (Object)templateId);
        if (dao == null) {
            throw ErrorCode.CLOUDTEMPLATE_NOT_FOUND.cloudManagerFault(templateId);
        }
        return new CloudTemplate(dao, this.getCloudService().getCloudTypeId());
    }

    @Override
    public List<CloudTemplate> findAllTemplates() throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        List daos = em.findByFilter(CloudTemplateDao.class, new Filter[]{new Filter("accountResourceId", new String[]{this.getAccountResource().getAccountResourceId()})});
        ArrayList<CloudTemplate> cloudTemplates = new ArrayList<CloudTemplate>();
        for (CloudTemplateDao dao : daos) {
            cloudTemplates.add(new CloudTemplate(dao, this.getCloudService().getCloudTypeId()));
        }
        return cloudTemplates;
    }

    @Override
    public List<String> findTemplateScripts() throws CloudManagerFault {
        String hinemosHome = System.getProperty("hinemos.manager.home.dir");
        File directory = new File(hinemosHome + "/" + CloudPropertyConstants.templatejob_script_file_dir.value());
        File[] files = directory.listFiles();
        ArrayList<String> scripts = new ArrayList<String>();
        for (File tmpFile : files) {
            if (!tmpFile.isFile()) continue;
            scripts.add(tmpFile.getName());
        }
        return scripts;
    }
}

