/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.commons;

import org.apache.log4j.Logger;

import com.clustercontrol.cloud.util.HinemosUtil;
import com.clustercontrol.commons.util.HinemosProperties;
import com.clustercontrol.repository.bean.NodeConstant;

public enum CloudPropertyConstants implements PropertyContract {
	billingalarm_notify_interval("hinemos.cloud.billing.notify.interval", "0 15 * * * ?"),

	autoupdate_node("hinemos.cloud.autoupdate.node", on, PropValidator.switchValidator),
	autoupdate_mount("hinemos.cloud.autoupdate.mount", on, PropValidator.switchValidator),
	autoupdate_instance("hinemos.cloud.autoupdate.instance", on, PropValidator.switchValidator),			
	autoupdate_storage("hinemos.cloud.autoupdate.storage", on, PropValidator.switchValidator),	// 未使用。
	autoupdate_backup("hinemos.cloud.autoupdate.backup", on, PropValidator.switchValidator),
	autoupdate_interval("hinemos.cloud.autoupdate.interval", "0 */10 * * * ?"),

	internal_thread_admin_user("hinemos.cloud.internal_thread.admin.user", "hinemos"),
	
	autoregist_scope_relation("hinemos.cloud.autoregist.scope.relation", on, PropValidator.switchValidator),
	autoregist_instance("hinemos.cloud.autoregist.instance", on, PropValidator.switchValidator),
	autoregist_storage("hinemos.cloud.autoregist.storage", on, PropValidator.switchValidator),

	password_crypt_key("hinemos.cloud.password.crypt.key", "hinemos"),

	registcheck_interval("hinemos.cloud.registcheck.interval", String.valueOf(10000), PropValidator.intValidator),
	registcheck_count("hinemos.cloud.registcheck.count", String.valueOf(30), PropValidator.intValidator),

	agent_connection_interval("agent.connection.interval", String.valueOf(10000), PropValidator.intValidator),
	agent_connection_count("agent.connection.count", String.valueOf(30), PropValidator.intValidator),
	
	templatejob_endcheck_interval("hinemos.cloud.templatejob.endcheck.interval", String.valueOf(10000), PropValidator.intValidator),
	templatejob_endcheck_count("hinemos.cloud.templatejob.endcheck.count", String.valueOf(30), PropValidator.intValidator),
	
	templatejob_script_file_dir("hinemos.cloud.templatejob.scriptfile.dir", "var/cloud/"),
	
	proxy("hinemos.cloud.proxy", on, PropValidator.switchValidator),
	
	node_property_agent_awakeport("hinemos.cloud.node.property.agent.awakeport",null),
	
	node_property_job_priority("hinemos.cloud.node.property.job.priority",null),
	node_property_job_multiplicity("hinemos.cloud.node.property.job.multiplicity",null),

	node_property_snmp_port("hinemos.cloud.node.property.snmp.port",null),
	node_property_snmp_community("hinemos.cloud.node.property.snmp.community",null),
	node_property_snmp_version("hinemos.cloud.node.property.snmp.version",null),
	node_property_snmp_timeout("hinemos.cloud.node.property.snmp.timeout",null),
	node_property_snmp_rRetries("hinemos.cloud.node.property.snmp.rRetries",null),

	node_property_wbem_user("hinemos.cloud.node.property.wbem.user",null),
	node_property_wbem_userpassword("hinemos.cloud.node.property.wbem.userpassword",null),
	node_property_wbem_port("hinemos.cloud.node.property.wbem.port",null),
	node_property_wbem_protocol("hinemos.cloud.node.property.wbem.protocol",null),
	node_property_wbem_timeout("hinemos.cloud.node.property.wbem.timeout",null),
	node_property_wbem_retries("hinemos.cloud.node.property.wbem.retries",null),

	node_property_ipmi_ipaddress("hinemos.cloud.node.property.ipmi.ipaddress",null),
	node_property_ipmi_port("hinemos.cloud.node.property.ipmi.port",null),
	node_property_ipmi_user("hinemos.cloud.node.property.ipmi.user",null),
	node_property_ipmi_userpassword("hinemos.cloud.node.property.ipmi.userpassword",null),
	node_property_ipmi_timeout("hinemos.cloud.node.property.ipmi.timeout",null),
	node_property_ipmi_retries("hinemos.cloud.node.property.ipmi.retries",null),
	node_property_ipmi_protocol("hinemos.cloud.node.property.ipmi.protocol",null),
	node_property_ipmi_level("hinemos.cloud.node.property.ipmi.level",null),
	
	node_property_winrm_user("hinemos.cloud.node.property.winrm.user",null),
	node_property_winrm_userpassword("hinemos.cloud.node.property.winrm.userpassword",null),
	node_property_winrm_version("hinemos.cloud.node.property.winrm.version",null),
	node_property_winrm_port("hinemos.cloud.node.property.winrm.port",null),
	node_property_winrm_protocol("hinemos.cloud.node.property.winrm.protocol",null),
	node_property_winrm_timeout("hinemos.cloud.node.property.winrm.timeout",null),
	node_property_winrm_retries("hinemos.cloud.node.property.winrm.retries",null),

	node_property_node_variablename("hinemos.cloud.node.property.node.variablename",null),
	node_property_node_variablevalue("hinemos.cloud.node.property.node.variablevalue",null),

	node_property_administrator("hinemos.cloud.node.property.administrator",null),
	node_property_contact("hinemos.cloud.node.property.contact",null),
	;

//	poller_retry_count("hinemos.cloud.poller.retry.count", String.valueOf(3), PropValidator.intValidator),
//	poller_retry_interval("hinemos.cloud.poller.retry.interval", String.valueOf(100), PropValidator.intValidator);
		
	public final String id;
	public final String value;
	public final PropValidator validator;

	static{
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.AGENT_AWAKE_PORT, node_property_agent_awakeport.value());
		
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.JOB_PRIORITY, node_property_job_priority.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.JOB_MULTIPLICITY, node_property_job_multiplicity.value());
		
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.SNMP_PORT, node_property_snmp_port.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.SNMP_COMMUNITY, node_property_snmp_community.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.SNMP_VERSION, node_property_snmp_version.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.SNMPTIMEOUT, node_property_snmp_timeout.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.SNMPRETRIES, node_property_snmp_rRetries.value());
		
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.WBEM_USER, node_property_wbem_user.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.WBEM_USER_PASSWORD, node_property_wbem_userpassword.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.WBEM_PORT, node_property_wbem_port.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.WBEM_PROTOCOL, node_property_wbem_protocol.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.WBEM_TIMEOUT, node_property_wbem_timeout.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.WBEM_RETRIES, node_property_wbem_retries.value());
		
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.IPMI_IP_ADDRESS, node_property_ipmi_ipaddress.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.IPMI_PORT, node_property_ipmi_port.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.IPMI_USER, node_property_ipmi_user.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.IPMI_USER_PASSWORD, node_property_ipmi_userpassword.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.IPMI_TIMEOUT, node_property_ipmi_timeout.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.IPMI_RETRIES, node_property_ipmi_retries.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.IPMI_PROTOCOL, node_property_ipmi_protocol.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.IPMI_LEVEL, node_property_ipmi_level.value());
		
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.WINRM_USER, node_property_winrm_user.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.WINRM_USER_PASSWORD, node_property_winrm_userpassword.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.WINRM_VERSION, node_property_winrm_version.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.WINRM_PORT, node_property_winrm_port.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.WINRM_PROTOCOL, node_property_winrm_protocol.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.WINRM_TIMEOUT, node_property_winrm_timeout.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.WINRM_RETRIES, node_property_winrm_retries.value());
		
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.NODE_VARIABLE_NAME, node_property_node_variablename.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.NODE_VARIABLE_VALUE, node_property_node_variablevalue.value());
		
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.ADMINISTRATOR, node_property_administrator.value());
		HinemosUtil.putUserDefinedNodePropertyList(NodeConstant.CONTACT, node_property_contact.value());
	}
	
	private CloudPropertyConstants(String id, String value) {
		this.id = id;
		this.value = value;
		this.validator = null;
	}

	private CloudPropertyConstants(String id, String value, PropValidator validator) {
		this.id = id;
		this.value = value;
		this.validator = validator;
	}
	
	public String value() {
		String prop = HinemosProperties.getProperty(id, value);
		if (validator != null) {
			try {
				validator.validate(prop);
			}
			catch (Exception e) {
				Logger logger = Logger.getLogger(CloudPropertyConstants.class);
				logger.error(id + " is invalid("+ prop +"), using default value(" + value + ").");
				prop = value;
			}
		}
		return prop;
	}

	public boolean match(String value) {
		return value().equals(value);
	}

	public String defaultValue() {
		return this.value;
	}
}
