/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.dao;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;


/**
 * 本当は、エンタープライズ側にあるべきクラス<BR>
 * eclipselink の weaving の問題で、CloudManagerBase へ移動。DB のスキーマも CloudManagerBase に含まれる。
 * 
 */
@Entity
@Table(name="cc_cloud_auto_control")
public class AutoControlDao extends HinemosObjectDao {
	public enum TriggerType {
		Schedule,
		Monitoring
	}
	
	private String autoControlId;
	private String accountResourceId;
	private String facilityId;
	private String resourceName;
	private String operationName;
	private TriggerType triggerType;
	private String jobScheduleId;
	private String jobNotyfyId;

	public AutoControlDao()
	{
	}

	public AutoControlDao(String autoControlId, String accountResourceId,
			String facilityId, String resourceName, String operationName,
			TriggerType triggerType, String jobScheduleId, String jobNotyfyId) {
		super();
		this.autoControlId = autoControlId;
		this.accountResourceId = accountResourceId;
		this.facilityId = facilityId;
		this.resourceName = resourceName;
		this.operationName = operationName;
		this.triggerType = triggerType;
		this.jobScheduleId = jobScheduleId;
		this.jobNotyfyId = jobNotyfyId;
	}

	public AutoControlDao(AutoControlDao otherData) {
		super(otherData);
		this.autoControlId = otherData.autoControlId;
		this.accountResourceId = otherData.accountResourceId;
		this.facilityId = otherData.facilityId;
		this.resourceName = otherData.resourceName;
		this.operationName = otherData.operationName;
		this.triggerType = otherData.triggerType;
		this.jobScheduleId = otherData.jobScheduleId;
		this.jobNotyfyId = otherData.jobNotyfyId;
	}

	@Id
	@Column(name="auto_control_id")
	public String getAutoControlId() {
		return autoControlId;
	}
	public void setAutoControlId(String autoControlId) {
		this.autoControlId = autoControlId;
	}

	@Column(name="account_resource_id")
	public String getAccountResourceId() {
		return accountResourceId;
	}
	public void setAccountResourceId(String accountResourceId) {
		this.accountResourceId = accountResourceId;
	}

	@Column(name="facility_id")
	public String getFacilityId() {
		return facilityId;
	}
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}

	@Column(name="resource_name")
	public String getResourceName() {
		return resourceName;
	}

	public void setResourceName(String resourceName) {
		this.resourceName = resourceName;
	}
	
	@Column(name="operation_name")
	public String getOperationName() {
		return operationName;
	}
	public void setOperationName(String operationName) {
		this.operationName = operationName;
	}

	@Column(name="trigger_type")
	@Enumerated(EnumType.STRING)
	public TriggerType getTriggerType() {
		return triggerType;
	}
	public void setTriggerType(TriggerType triggerType) {
		this.triggerType = triggerType;
	}

	@Column(name="job_schedule_id")
	public String getJobScheduleId() {
		return jobScheduleId;
	}
	public void setJobScheduleId(String jobScheduleId) {
		this.jobScheduleId = jobScheduleId;
	}

	@Column(name="job_notyfy_id")
	public String getJobNotyfyId() {
		return jobNotyfyId;
	}
	public void setJobNotyfyId(String jobNotyfyId) {
		this.jobNotyfyId = jobNotyfyId;
	}

	@Override
	public String toString() {
		return "AutoControlDao [autoControlId=" + autoControlId
				+ ", accountResourceId=" + accountResourceId + ", facilityId="
				+ facilityId + ", resourceName=" + resourceName
				+ ", operationName=" + operationName + ", triggerType="
				+ triggerType + ", jobScheduleId=" + jobScheduleId
				+ ", jobNotyfyId=" + jobNotyfyId + "]";
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		AutoControlDao other = (AutoControlDao) obj;
		if (accountResourceId == null) {
			if (other.accountResourceId != null)
				return false;
		} else if (!accountResourceId.equals(other.accountResourceId))
			return false;
		if (autoControlId == null) {
			if (other.autoControlId != null)
				return false;
		} else if (!autoControlId.equals(other.autoControlId))
			return false;
		if (facilityId == null) {
			if (other.facilityId != null)
				return false;
		} else if (!facilityId.equals(other.facilityId))
			return false;
		if (jobNotyfyId == null) {
			if (other.jobNotyfyId != null)
				return false;
		} else if (!jobNotyfyId.equals(other.jobNotyfyId))
			return false;
		if (jobScheduleId == null) {
			if (other.jobScheduleId != null)
				return false;
		} else if (!jobScheduleId.equals(other.jobScheduleId))
			return false;
		if (operationName == null) {
			if (other.operationName != null)
				return false;
		} else if (!operationName.equals(other.operationName))
			return false;
		if (resourceName == null) {
			if (other.resourceName != null)
				return false;
		} else if (!resourceName.equals(other.resourceName))
			return false;
		if (triggerType != other.triggerType)
			return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime
				* result
				+ ((accountResourceId == null) ? 0 : accountResourceId
						.hashCode());
		result = prime * result
				+ ((autoControlId == null) ? 0 : autoControlId.hashCode());
		result = prime * result
				+ ((facilityId == null) ? 0 : facilityId.hashCode());
		result = prime * result
				+ ((jobNotyfyId == null) ? 0 : jobNotyfyId.hashCode());
		result = prime * result
				+ ((jobScheduleId == null) ? 0 : jobScheduleId.hashCode());
		result = prime * result
				+ ((operationName == null) ? 0 : operationName.hashCode());
		result = prime * result
				+ ((resourceName == null) ? 0 : resourceName.hashCode());
		result = prime * result
				+ ((triggerType == null) ? 0 : triggerType.hashCode());
		return result;
	}

	@Override
	public String getId() {
		return getAutoControlId();
	}
}
