/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.dao;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Table;

import com.clustercontrol.cloud.dao.CloudRegionDao.CloudRegionPK;
import com.clustercontrol.cloud.persistence.IDHolder;

/**
 * インスタンス情報のBMP Entity Bean クラス<BR>
 */
@Entity
@Table(name="cc_cloud_endpoint")
@IdClass(CloudEndpointDao.CloudEndpointPK.class)
public class CloudEndpointDao implements IDHolder {
	public static class CloudEndpointPK extends java.lang.Object implements java.io.Serializable {
		/**
		 * 
		 */
		private static final long serialVersionUID = 682905935857533293L;

		public CloudRegionPK region;
		public String endpointType;

		public CloudEndpointPK() {
		}

		public CloudEndpointPK(CloudRegionPK region, String type) {
			this.region = region;
			this.endpointType = type;
		}

		public CloudRegionPK getRegion() {
			return region;
		}

		public void setRegion(CloudRegionPK region) {
			this.region = region;
		}

		@Column(name="ep_type")
		public String getEndpointType() {
			return endpointType;
		}

		public void setEndpointType(String type) {
			this.endpointType = type;
		}

		public int hashCode() {
			int _hashCode = 0;
			if (this.region != null)
				_hashCode += this.region.hashCode();
			if (this.endpointType != null)
				_hashCode += this.endpointType.hashCode();

			return _hashCode;
		}

		public boolean equals(Object obj) {
			if (!(obj instanceof CloudEndpointPK))
				return false;

			CloudEndpointPK pk = (CloudEndpointPK) obj;
			boolean eq = true;

			if (this.region != null) {
				eq = eq && this.region.equals(pk.getRegion());
			} else
			{
				eq = eq && (pk.getRegion() == null);
			}
			if (this.endpointType != null) {
				eq = eq && this.endpointType.equals(pk
								.getEndpointType());
			} else
			{
				eq = eq && (pk.getEndpointType() == null);
			}

			return eq;
		}

		public String toString() {
			StringBuffer toStringValue = new StringBuffer("[.");
			toStringValue.append(this.region).append('.');
			toStringValue.append(this.endpointType).append('.');
			toStringValue.append(']');
			return toStringValue.toString();
		}

	}
	
	public CloudRegionDao region;
	private String endpointType;
	public String location;
	
	public CloudEndpointDao()
	{
	}

	public CloudEndpointDao( CloudRegionDao region,String type,String location )
	{
		setRegion(region);
		setEndpointType(type);
		setLocation(location);
	}

	public CloudEndpointDao( CloudEndpointDao otherData )
	{
		setRegion(otherData.getRegion());
		setEndpointType(otherData.getEndpointType());
		setLocation(otherData.getLocation());
	}

	@Id
	@JoinColumns (
	    {
	    	@JoinColumn(name="region", referencedColumnName="region"),
	    	@JoinColumn(name="cloud_service_id", referencedColumnName="cloud_service_id")
	    }
	)
	public CloudRegionDao getRegion() {
		return region;
	}

	public void setRegion(CloudRegionDao region) {
		this.region = region;
	}

	@Id
	@Column(name="ep_type")
	public String getEndpointType() {
		return endpointType;
	}

	public void setEndpointType(String type) {
		this.endpointType = type;
	}
	
	@Column(name="location")
	public String getLocation()
	{
		return this.location;
	}
	public void setLocation( String location )
	{
		this.location = location;
	}

	public String toString()
	{
		StringBuffer str = new StringBuffer("{");

		str.append("region=" + getRegion() + " " + "endpointType=" + getEndpointType() + " " + "location=" + getLocation());
		
		str.append('}');

		return(str.toString());
	}

	public boolean equals( Object pOther )
	{
		if( pOther instanceof CloudEndpointDao )
		{
			CloudEndpointDao lTest = (CloudEndpointDao) pOther;
			boolean lEquals = true;

			if( this.region == null )
			{
				lEquals = lEquals && ( lTest.region == null );
			}
			else
			{
				lEquals = lEquals && this.region.equals( lTest.region );
			}
			if( this.endpointType == null )
			{
				lEquals = lEquals && ( lTest.endpointType == null );
			}
			else
			{
				lEquals = lEquals && this.endpointType.equals( lTest.endpointType );
			}
			if( this.location == null )
			{
				lEquals = lEquals && ( lTest.location == null );
			}
			else
			{
				lEquals = lEquals && this.location.equals( lTest.location );
			}

			return lEquals;
		}
		else
		{
			return false;
		}
	}

	public int hashCode()
	{
		int result = 17;

		result = 37*result + ((this.region != null) ? this.region.hashCode() : 0);

		result = 37*result + ((this.endpointType != null) ? this.endpointType.hashCode() : 0);

		result = 37*result + ((this.location != null) ? this.location.hashCode() : 0);

		return result;
	}

	@Override
	public CloudEndpointDao.CloudEndpointPK getId() {
		return new CloudEndpointDao.CloudEndpointPK(getRegion().getId(), getEndpointType());
	}
}
