//package com.clustercontrol.cloud.validation;
//
//import java.lang.annotation.ElementType;
//import java.lang.annotation.Retention;
//import java.lang.annotation.RetentionPolicy;
//import java.lang.annotation.Target;
//
//import com.clustercontrol.cloud.CloudManagerFault;
//import com.clustercontrol.cloud.ErrorCode;
//import com.clustercontrol.cloud.MessagesHolder;
//import com.clustercontrol.cloud.SessionContextService;
//import com.clustercontrol.cloud.util.CloudUtil;
//import com.clustercontrol.cloud.validation.ValidationUtil.AbstractValidator;
//import com.clustercontrol.cloud.validation.annotation.ValidatedBy;
//
//@Retention(RetentionPolicy.RUNTIME)  
//@Target({ElementType.METHOD, ElementType.PARAMETER})
//@ValidatedBy(com.clustercontrol.cloud.validation.HaveAccountResourceAccount.Validator.class)
//public @interface HaveAccountResourceAccount {
//	public class Validator extends AbstractValidator<HaveAccountResourceAccount, String> {
//		@Override
//		public void init(HaveAccountResourceAccount annotation) {
//			setElementId(annotation.elementId());
//			setValidationId(annotation.validationId());
//			setGroups(annotation.groups());
//		}
//
//		@Override
//		protected void internalValidate(String property, String group, MessagesHolder messages) throws ValidationFault {
//			if (property == null || property.isEmpty()) {
//				return;
//			}
//			
//			try {
//				if (!CloudUtil.isAccountResourceAccount(property)) {
//					throw new ValidationFault(
//							ErrorCode.ACCOUNTRESOURCE_MUST_HAVE_ACCOUNT.getMessage(SessionContextService.context().getHinemosCredential().getUserId()),
//							ErrorCode.ACCOUNTRESOURCE_MUST_HAVE_ACCOUNT.name());
//				}
//			}
//			catch (CloudManagerFault e) {
//				throw new ValidationFault(e.getMessage(), e.getErrorCode(), e);
//			}
//		}
//	}
//	
//	String elementId() default "";
//	String validationId() default "com.clustercontrol.cloud.validation.HaveAccountResourceAccount";
//	String[] groups() default {};
//}