#!/bin/bash

#Copyright (C) 2013 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or 
#Modify it under the terms of the GNU General Public License 
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful, 
#but WITHOUT ANY WARRANTY; without even the implied warranty of 
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
#GNU General Public License for more details

SCRIPT_DIR=$(cd $(dirname $0);pwd)

. ${SCRIPT_DIR}/scripts/cloud_install_function.sh

set_hinemos_home

. ${HINEMOS_HOME}/hinemos.cfg
. ${SCRIPT_DIR}/scripts/conf.sh

check_version ${DEPENDENCY_VER_FILE} ${REQUIRED_VERSION} ${DEPENDENCY_MODULE_NAME}

echo ----- ${OPTION_PACKAGE_NAME} start ----------
install_settings ${SCRIPT_DIR} ${HINEMOS_HOME}

install_libraries ${LIBDIR} ${PLUGINS_DIR} ${PLUGINS_IN_PACKAGE_DIR} ${INSTALL_USER} ${INSTALL_GROUP} "${INSTALL_LIBRARIES}"

echo ${VERSION_NUMBER} | cat > ${HINEMOS_HOME}/${VERSION_FILE_NAME} 
chown ${INSTALL_USER}:${INSTALL_GROUP} ${HINEMOS_HOME}/${VERSION_FILE_NAME}

echo ----- ${OPTION_PACKAGE_NAME} end   ----------
echo
echo ----- db start  ------------

unset PGPASSWORD
if [ -n "${TABLE_SCRIPT}" ]; then
	db_manipulate ${PG_HOME} ${PG_USER} "${TABLE_SCRIPT}"
fi
if [ -n "${DATA_SCRIPT}" ]; then
	db_manipulate ${PG_HOME} ${PG_USER} "${DATA_SCRIPT}"
fi

echo ----- db end   -------------
echo
echo ----- add hinemos.properties start -------------
HINEMOS_PROPERTIES=${HINEMOS_HOME}/etc/hinemos.properties
echo "" >> ${HINEMOS_PROPERTIES}
echo "" >> ${HINEMOS_PROPERTIES}
echo "## Cloud Management for AWS" >> ${HINEMOS_PROPERTIES}
echo "add hinemos.cloud.aws.instance.type to ${HINEMOS_PROPERTIES}"
echo "hinemos.cloud.aws.instance.type=t2.micro,t2.small,t2.medium,m3.medium,m3.large,m3.xlarge,m3.2xlarge,c4.large,c4.xlarge,c4.2xlarge,c4.4xlarge,c4.8xlarge,c3.large,c3.xlarge,c3.2xlarge,c3.4xlarge,c3.8xlarge,g2.2xlarge,r3.large,r3.xlarge,r3.2xlarge,r3.4xlarge,r3.8xlarge,i2.xlarge,i2.2xlarge,i2.4xlarge,i2.8xlarge,hs1.8xlarge,t1.micro,m1.small,m1.medium,m1.large,m1.xlarge,c1.medium,c1.xlarge,cc2.8xlarge,cg1.4xlarge,m2.xlarge,m2.2xlarge,m2.4xlarge,cr1.8xlarge,hi1.4xlarge" >> ${HINEMOS_PROPERTIES}
echo "" >> ${HINEMOS_PROPERTIES}
echo ----- add hinemos.properties end   -------------
echo
echo install succeeded !
exit 0
