#!/bin/bash

#Copyright (C) 2013 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or 
#Modify it under the terms of the GNU General Public License 
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful, 
#but WITHOUT ANY WARRANTY; without even the implied warranty of 
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
#GNU General Public License for more details

SCRIPT_DIR=$(cd $(dirname $0);pwd)

. ${SCRIPT_DIR}/scripts/cloud_install_function.sh

set_hinemos_home

. ${HINEMOS_HOME}/hinemos.cfg
. ${SCRIPT_DIR}/scripts/conf.sh

uninstall_libraries "${INSTALL_FILES}"
deregist_persistence "${ENTITY_JARS}" ${LIBDIR} ${PERSISTENCE_XML_PATH} "${ORM_XML_PATHS}"
uninstall_settings ${SCRIPT_DIR} ${HINEMOS_HOME}

if [ -n "${DATA_SCRIPT}" ]; then
	db_manipulate ${PG_HOME} ${PG_USER} "${DATA_SCRIPT}"
fi
if [ -n "${TABLE_SCRIPT}" ]; then
	db_manipulate ${PG_HOME} ${PG_USER} "${TABLE_SCRIPT}"
fi

echo uninstall end

exit 0