/*
Copyright (C) 2013 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
*/
package com.clustercontrol.cloud.aws;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.log4j.Logger;

import com.clustercontrol.cloud.CloudManagerBaseService;
import com.clustercontrol.cloud.CloudPlugin;
import com.clustercontrol.cloud.ICloudOption;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.IUserManagement;
import com.clustercontrol.cloud.PluginFault;
import com.clustercontrol.cloud.aws.factory.AWSOption;
import com.clustercontrol.cloud.aws.factory.AWSResourceManagement;
import com.clustercontrol.cloud.aws.factory.AWSUserManagement;
import com.clustercontrol.cloud.aws.util.AWSConstants;
import com.clustercontrol.cloud.commons.CloudConstants;
import com.clustercontrol.cloud.registry.AbstractObjectChangedListener;
import com.clustercontrol.cloud.registry.IObjectChangedService;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.bean.NodeVariableInfo;
import com.clustercontrol.ws.aws.AWSOptionEndpointImpl;

public class AWSManagerBaseService extends CloudPlugin {
	public final static String id = "com.clustercontrol.cloud.aws.AWSdManagerBaseService";
	
	private static AWSManagerBaseService singleton;
	
	/**
	 * CloudServiceのコンストラクタ
	 */
	public AWSManagerBaseService() {
		super();
		singleton = this;
	}

	@Override
	public Set<String> getDependency() {
		Set<String> set = new HashSet<>();
		set.add(CloudManagerBaseService.class.getName());
		return set;
	}

	@Override
	public void create() {
		Logger logger = Logger.getLogger(this.getClass());

		// メイン処理
		logger.info("creating " + getClass().getSimpleName() + "...");
		
		//　プロパティ一覧の表示
		for (AWSOptionPropertyConstants value: AWSOptionPropertyConstants.values()) {
			logger.info(value.id + " = " + value.value() + " (" + value.defaultValue() + ")");
		}
		
		logger.info("successful in creating " + getClass().getSimpleName() + "...");
	}

	@Override
	public void activate() {
		Logger logger = Logger.getLogger(this.getClass());

		// メイン処理
		logger.info("starting " + getClass().getSimpleName() + "...");
		
		logger.info("successful in starting " + getClass().getSimpleName() + "...");
	}

	@Override
	public void deactivate() {
		Logger logger = Logger.getLogger(this.getClass());

		// メイン処理
		logger.info("stopping " + getClass().getSimpleName() + "...");
		
		logger.info("successful in stopping " + getClass().getSimpleName() + "...");
	}

	@Override
	public void destroy() {
		Logger logger = Logger.getLogger(this.getClass());

		// メイン処理
		logger.info("destroying " + getClass().getSimpleName() + "...");
		
		logger.info("successful in destroying " + getClass().getSimpleName() + "...");
	}
	
	public static AWSManagerBaseService getSingleton() {
		return singleton;
	}

	@Override
	public String getPluginId() {
		return id;
	}

	@Override
	public void initialize() {
		Logger logger = Logger.getLogger(this.getClass());

		// メイン処理
		logger.info("initializing " + getClass().getSimpleName() + "...");
		
		ObjectRegistryService.registry().put(ICloudOption.class, AWSConstants.TYPE_ID, AWSOption.class);
		ObjectRegistryService.registry().put(IUserManagement.class, AWSConstants.TYPE_ID, AWSUserManagement.class);
		ObjectRegistryService.registry().put(IResourceManagement.class, AWSConstants.TYPE_ID, AWSResourceManagement.class);
		
		CloudManagerBaseService.getSingleton().publish("/HinemosWS/AWSOptionEndpoint", new AWSOptionEndpointImpl());

		IObjectChangedService service = ObjectRegistryService.registry().get(IObjectChangedService.class);
		service.addObjectChangedListener(CloudConstants.Node_Instance_Modify, NodeInfo.class, new AbstractObjectChangedListener<NodeInfo>() {
			@Override
			public void preModified(String type, NodeInfo object) throws PluginFault {
				if (!AWSConstants.SERVICE_ID.equals(object.getCloudService())) return;
				
				// リソース監視用のノード変数を追加する処理。
				NodeVariableInfo instaceId = null;
				List<NodeVariableInfo> variables = object.getNodeVariableInfo();
				for (NodeVariableInfo variable: variables) {
					if (variable.getNodeVariableName().equals(AWSConstants.CloudWatch_IntanceId)) {
						variable.setNodeVariableValue(object.getCloudResourceId());
						instaceId = variable;
						break;
					}
				}
				
				if (instaceId == null) {
					List<NodeVariableInfo> newVariables = new ArrayList<>(variables);
					newVariables.add(new NodeVariableInfo(AWSConstants.CloudWatch_IntanceId, object.getCloudResourceId()));
					object.setNodeVariableInfo(new ArrayList<>(newVariables));
				}
			}
		});
		
		service.addObjectChangedListener(CloudConstants.Node_Instance_Add, NodeInfo.class, new AbstractObjectChangedListener<NodeInfo>() {
			@Override
			public void preAdded(String type, NodeInfo object) throws PluginFault {
				if (!AWSConstants.SERVICE_ID.equals(object.getCloudService())) return;

				// リソース監視用のノード変数を追加する処理。
				object.getNodeVariableInfo().add(new NodeVariableInfo(AWSConstants.CloudWatch_IntanceId, object.getCloudResourceId()));
			}
		});
		
		service.addObjectChangedListener(CloudConstants.Node_Instance_Clear, NodeInfo.class, new AbstractObjectChangedListener<NodeInfo>() {
			@Override
			public void preModified(String type, NodeInfo object) throws PluginFault {
				if (!AWSConstants.SERVICE_ID.equals(object.getCloudService())) return;

				// リソース監視用のノード変数を削除する処理。
				for (NodeVariableInfo var: object.getNodeVariableInfo()) {
					if (AWSConstants.CloudWatch_IntanceId.equals(var.getNodeVariableName())) {
						object.getNodeVariableInfo().remove(var);
						break;
					}
				}
			}
		});
		
		logger.info("successful in initializing " + getClass().getSimpleName() + "...");
	}
}
