/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.util;

public enum AWSErrorCode {
	InvalidVolume_NotFound("InvalidVolume.NotFound"),
	InvalidInstanceID_NotFound("InvalidInstanceID.NotFound"),
	InvalidGroup_NotFound("InvalidGroup.NotFound"),
	OperationNotPermitted("OperationNotPermitted"),
	InvalidAMIID_NotFound("InvalidAMIID.NotFound"),
	InvalidSnapshot_NotFound("InvalidSnapshot.NotFound");
	
	private String label;
	
	private AWSErrorCode(String label) {
		this.label = label;
	}
	
	public String label() {
		return label;
	}
	
	public boolean match(String errorCode) {
		return label.equals(errorCode);
	}

	public String toString() {
		return label;
	}
}
