/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.util;

import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.ws.aws.IpPermission;
import com.clustercontrol.ws.aws.SecurityGroup;
import com.clustercontrol.ws.aws.UserIdGroupPair;

public class SecurityGroupUtil {
	public static SecurityGroup convertToSecrurityGroup(com.amazonaws.services.ec2.model.SecurityGroup awsSg){
		SecurityGroup sg = new SecurityGroup();
		sg.setOwnerId(awsSg.getOwnerId());
		sg.setGroupId(awsSg.getGroupId());
		sg.setGroupName(awsSg.getGroupName());
		sg.setDescription(awsSg.getDescription());
		sg.setVpcId(awsSg.getVpcId());

		List<IpPermission> ipPermissions = new ArrayList<IpPermission>();
		for(com.amazonaws.services.ec2.model.IpPermission awsIpPermission: awsSg.getIpPermissions()){
			IpPermission ipPermission = convertToIpPermission(awsIpPermission);
			ipPermissions.add(ipPermission);
		}
		sg.setIpPermissions(ipPermissions);

		List<IpPermission> ipPermissionsEgress = new ArrayList<IpPermission>();
		for(com.amazonaws.services.ec2.model.IpPermission awsIpPermission: awsSg.getIpPermissionsEgress()){
			IpPermission ipPermission = convertToIpPermission(awsIpPermission);
			ipPermissionsEgress.add(ipPermission);
		}
		sg.setIpPermissionsEgress(ipPermissionsEgress);
		return sg;
	}
	
	public static IpPermission convertToIpPermission(com.amazonaws.services.ec2.model.IpPermission awsIpPermission){
		IpPermission ipPermission = new IpPermission();
		ipPermission.setFromPort(awsIpPermission.getFromPort());
		ipPermission.setToPort(awsIpPermission.getToPort());
		ipPermission.setIpProtocol(awsIpPermission.getIpProtocol());
		ipPermission.setIpRanges(awsIpPermission.getIpRanges());

		List<UserIdGroupPair> userIdGroupPairs = new ArrayList<UserIdGroupPair>();
		for (com.amazonaws.services.ec2.model.UserIdGroupPair uig: awsIpPermission.getUserIdGroupPairs()) {
			UserIdGroupPair pair = new UserIdGroupPair();
			pair.setGroupId(uig.getGroupId());
			pair.setGroupName(uig.getGroupName());
			pair.setUserId(uig.getUserId());
		}

		ipPermission.setUserIdGroupPairs(userIdGroupPairs);
		return ipPermission;
	}

//	public static com.amazonaws.services.ec2.model.IpPermission convertToAwsIpPermission(IpPermission permission){
//		com.amazonaws.services.ec2.model.IpPermission awsPermission = new com.amazonaws.services.ec2.model.IpPermission();
//		awsPermission.setFromPort(permission.getFromPort());
//		awsPermission.setToPort(permission.getToPort());
//		awsPermission.setIpProtocol(permission.getIpProtocol());
//		if(permission.getIpRange() != null && !"".equals(permission.getIpRange())){
//			List<String> ipRanges = new ArrayList<String>();
//			ipRanges.add(permission.getIpRange());
//			awsPermission.setIpRanges(ipRanges);
//		} else {
//			List<UserIdGroupPair> pairs = new ArrayList<UserIdGroupPair>();
//			UserIdGroupPair pair = new UserIdGroupPair();
//			if(permission.getSecurityGroupId() != null && !"".equals(permission.getSecurityGroupId())){
//				pair.setGroupId(permission.getSecurityGroupId());
//			} else if(permission.getUserId() != null && !"".equals(permission.getUserId())
//				&& permission.getGroupName() != null && !"".equals(permission.getGroupName())){
//				pair.setGroupName(permission.getGroupName());
//				pair.setUserId(permission.getUserId());
//			}
//			pairs.add(pair);
//			awsPermission.setUserIdGroupPairs(pairs);
//		}
//		return awsPermission;
//	}
}
