
package com.clustercontrol.ws.xcloud;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>entryTypeのJavaクラス。
 * 
 * <p>次のスキーマ・フラグメントは、このクラス内に含まれる予期されるコンテンツを指定します。
 * <p>
 * <pre>
 * &lt;simpleType name="entryType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="cloud"/>
 *     &lt;enumeration value="user"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "entryType")
@XmlEnum
public enum EntryType {

    @XmlEnumValue("cloud")
    CLOUD("cloud"),
    @XmlEnumValue("user")
    USER("user");
    private final String value;

    EntryType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static EntryType fromValue(String v) {
        for (EntryType c: EntryType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
