package com.clustercontrol.xcloud.model.base;

import com.clustercontrol.xcloud.model.base.IUpdatable.ElementListerner;

/**
 * 要素の更新時に発生するイベント。
 * 
 * @author torun
 *
 */
public class UpdateEvent extends Event<IElement, ElementListerner> {
	private static ListenerType<ElementListerner> TYPE = new ListenerType<ElementListerner>(){};

	public UpdateEvent(IElement source) {
		super(source);
	}
	public void dispatch(ElementListerner listener) {
		listener.elementUpdated(this);
	}
	public ListenerType<ElementListerner> getAssociatedType() {
		return getType();
	}
	public static ListenerType<ElementListerner> getType() {
		return TYPE;
	}
}