package com.clustercontrol.xcloud.platform.rcp;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import javax.activation.DataHandler;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.ws.xcloud.TargetType;
import com.clustercontrol.xcloud.platform.PlatformDependent;
import com.clustercontrol.xcloud.ui.dialogs.DetailDialog;

public class RCPPlatformDependent extends PlatformDependent {

	@Override
	public DetailDialog createDetailDialog(Shell parentShell, String dialogTitle) {
		return new DetailDialog(parentShell, dialogTitle) {
			@Override
			protected Control createDialogArea(Composite parent) {
				Composite container = new Composite(parent, SWT.FILL);
				container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
				GridData gd_container = new GridData(SWT.FILL, SWT.FILL, true, true, 20, 1);
				gd_container.verticalAlignment = SWT.FILL;
				gd_container.horizontalAlignment = SWT.FILL;
				container.setLayoutData(gd_container);
				container.setLayout(new GridLayout(1, false));
				
				StyledText detail = new StyledText(container, SWT.BORDER | SWT.READ_ONLY | SWT.WRAP);
				detail.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
				if(this.input != null){
					detail.setText(input);
				}
				return container;
			}
		};
	}

	@Override
	public void downloadBillingDetail(Shell parent, TargetType type, String targetId, int year, int month, DataHandler handler) throws Exception {
		FileDialog dialog = new FileDialog(parent, SWT.SAVE);
		String filename = null;
		switch (type) {
		case FACILITY:
			filename = String.format("hinemos_cloud_billing_detail_facility_%s_%04d%02d.csv.zip", targetId, year, month);
			break;
		case CLOUD_SCOPE:
			filename = String.format("hinemos_cloud_billing_detail_account_%s_%04d%02d.csv.zip", targetId, year, month);
			break;
		}
		
		dialog.setFileName(filename);
		dialog.setFilterExtensions(new String[]{"*.zip"});
		dialog.setOverwrite(true);
		String filePath = dialog.open();
		
		if (filePath == null) return;

		try (InputStream is = handler.getInputStream()) {
			Files.copy(is, new File(filePath).toPath(), StandardCopyOption.REPLACE_EXISTING);
		}
	}

	@Override
	public boolean isRapPlatfome() {
		return false;
	}
}
