/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.model.base;




public interface ValueObserver<P> extends PropertyObserver<P> {
	public class ValueChangedEvent<P> extends PropEvent<P, ValueObserver<P>> {
		private P newValue;
		private P oldValue;
		public ValueChangedEvent(Object source, PropertyId<ValueObserver<P>> pid, P newValue, P oldValue) {
			super(source, pid);
			this.newValue = newValue;
			this.oldValue = oldValue;
		}
		public P getNewValue() {
			return newValue;
		}
		public P getOldValue() {
			return oldValue;
		}
		@Override
		public void dispatch(ValueObserver<P> observer) {
			if ((getNewValue() != null && !getNewValue().equals(getOldValue())) || getNewValue() != getOldValue()) {
				observer.propertyChanged(this);
			}
		}
	}
	void propertyChanged(ValueChangedEvent<P> event);
}