/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.model.cloud;

import java.util.List;

import com.clustercontrol.ws.xcloud.Credential;
import com.clustercontrol.ws.xcloud.ModifyCloudLoginUserRequest;
import com.clustercontrol.xcloud.model.base.IElement;
import com.clustercontrol.xcloud.model.base.PropertyId;
import com.clustercontrol.xcloud.model.base.ValueObserver;

public interface ILoginUser extends IElement {
	// プロパティの Id
	public interface p {
		static final PropertyId<ValueObserver<String>> name = new PropertyId<ValueObserver<String>>("name"){};
		static final PropertyId<ValueObserver<String>> description = new PropertyId<ValueObserver<String>>("description"){};
		static final PropertyId<ValueObserver<Integer>> priority = new PropertyId<ValueObserver<Integer>>("priority"){};
		static final PropertyId<ValueObserver<String>> cloudUserType = new PropertyId<ValueObserver<String>>("cloudUserType"){};
		static final PropertyId<ValueObserver<List<IRoleRelation>>> roleRelations = new PropertyId<ValueObserver<List<IRoleRelation>>>("roleRelations"){};
		static final PropertyId<ValueObserver<Credential>> credential = new PropertyId<ValueObserver<Credential>>("credential"){};
		static final PropertyId<ValueObserver<Long>> updateDate = new PropertyId<ValueObserver<Long>>("updateDate"){};
		static final PropertyId<ValueObserver<String>> updateUser = new PropertyId<ValueObserver<String>>("updateUser"){};
	}

	String getId();
	String getName();
	String getDescription();
	String getCloudScopeId();
	String getCloudUserType();
	Integer getPriority();
	IRoleRelation[] getRoleRelations();
	Credential getCredential();
	Long getRegDate();
	String getRegUser();
	Long getUpdateDate();
	String getUpdateUser();

	ILoginUsers getCloudUserManager();
	ILoginUser modifyCloudUser(ModifyCloudLoginUserRequest request);
	
	void addRoleRelation(String roleId);
	void removeRoleRelation(String roleId);
}
